﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading;

namespace SignaWorksAlarmPlugin
{
    public class MySocketClient
    {
        // Background thread
        private bool _bStopRequested;
        // For logging
        // Attachment checking
        ManualResetEvent _attachedOK;
        // TCP Client
        private TcpClient _client;
        // Parsing
        private StringBuilder _partial_line;
        private DateTime _last_good_read;
        private Logger<MySocketClient> Logger { get;}
        public bool DebugMode { get; }

        public event EventHandler<byte[]> DataRead;
        public event EventHandler Disconnected;
        public event EventHandler<string> InfoMessage;

        public MySocketClient(bool debugMode)
        {
            // Attachment checking
            Logger = new Logger<MySocketClient>(debugMode);
            _attachedOK = new ManualResetEvent(false);
            DebugMode = debugMode;
        }

        public bool Connect(string hostname, int port)
        {
            _client = new TcpClient();            
            Logger.Write("Connect 1");
            // Try an async connection attempt - this may take 20 seconds to return a result
            _attachedOK.Reset();
            Logger.Write("Connect 2");
            IAsyncResult ar = _client.BeginConnect(hostname, port, new AsyncCallback(HandleConnect), _client);
            Logger.Write("Connect 3 post begin connect");
            // Wait up to six seconds
            bool bSuccess = _attachedOK.WaitOne(6000, false);
            Logger.Write("Connect 3 success=" + bSuccess);
            if (bSuccess)
            {
                Thread worker_thread = new Thread(new ThreadStart(RunClient));
                worker_thread.IsBackground = true;
                worker_thread.Start();
            }
            return bSuccess;
        }

        private void RunClient()
        {
            _bStopRequested = false;
            _partial_line = new StringBuilder();
            _last_good_read = DateTime.Now;
            try
            {
                while (!_bStopRequested)
                {
                    if (_client.Available > 0)
                    {
                        byte[] buffer = new byte[_client.Available];
                        _client.GetStream().Read(buffer, 0, buffer.Length);
                        _last_good_read = DateTime.Now;
                        handleBuffer(buffer);
                    }
                    else
                    {
                        Thread.Sleep(1000);
                    }
                    double secondsSince = DateTime.Now.Subtract(_last_good_read).TotalSeconds;
                    //Logger.Write("Seconds Since = " + secondsSince);
                    if (secondsSince > 30)
                    {
                        throw new Exception("Light Stack has timed out.");
                    }
                }
                int aoeaoeaoeuaeo = 3;
            }
            catch (Exception ex)
            {
                _bStopRequested = true;
                // Log all exceptions on background threads
                string excMessage = "VTAG Client Handler Got Exception: " + ex.Message;
                // Inform the user of all exceptions on background threads       
                InfoMessage?.Invoke(this, excMessage);
                // Disconnect
                //DeviceLock.releaseDeviceLock(this, "READER->" + _reader_record.Name);
                Disconnected?.Invoke(this, EventArgs.Empty);
            }
            finally
            {
                Logger.Write("Closing Client.");
                close_client();
            }
        }//RunClient

        // Close the client connection
        private void close_client()
        {
            try
            {
                _client.Close();
                _client = null;
            }
            catch (Exception exc)
            {
                ;
            }
        }

        // Handle a buffer full of new data
        private void handleBuffer(byte[] buffer)
        {
            DataRead?.Invoke(this, buffer);
        }

        public void Disconnect()
        {
            _bStopRequested = true;
        }

        public void WriteLine(string line)
        {
            // Write the line to the stream
            StreamWriter sw = new StreamWriter(_client.GetStream());
            sw.Write(line);
            sw.Write("\r\n");
            sw.Flush();
        }


        public void Write(byte[] bytes)
        {
            var ns = _client.GetStream();
            ns.Write(bytes, 0, bytes.Length);
        }

        // Handle notification of a socket connect
        void HandleConnect(IAsyncResult ar)
        {
            TcpClient client = (TcpClient)ar.AsyncState;
            try
            {
                client.EndConnect(ar);
                Logger.Write("HandleConnect.Set");
                _attachedOK.Set();
            }
            catch (Exception e)
            {

            }
        }

    }
}
