﻿using AssetWorx.Entities;
using AssetWorx.Plugin;
using System.IO;
using System;
using AssetWorx.Entities.Libs;

namespace AssetWorx_Plugin
{
    public class SimpleLogCustomAction : ICustomAction
    {
        public const string LOGDIRECTORY = @"C:\Logs";
        public const string LOGPATH = @"C:\Logs\SimpleLogCustomAction.txt";

        public string Name => "Simple Log Custom Action";

        public void Dispose()
        {
            //No resources to release
            File.AppendAllText(LOGPATH, string.Format("*********Simple Log Custom Action Disposed*********{0}",Environment.NewLine));
        }

        public void DoAction(TagObservation tagMovement)
        {
            File.AppendAllText(LOGPATH, string.Format("Logging event for asset with tag {0} {1} ", tagMovement.TagID, Environment.NewLine));

        }

        public void DoAction(AlarmIndication alarmIndication)
        {
            File.AppendAllText(LOGPATH, string.Format("Logging event for asset with tag {0} {1} ", alarmIndication.TagID, Environment.NewLine));

        }

        public void Initialize()
        {
            if (!Directory.Exists(LOGDIRECTORY))
                Directory.CreateDirectory(LOGDIRECTORY);
            if (File.Exists(LOGPATH))
                File.Delete(LOGPATH);
            File.AppendAllText(LOGPATH, string.Format("*********Simple Log Custom Action Initialized*********{0}", Environment.NewLine));

            //YOU CAN ALSO INIT TIMERS HERE TO PERIODICALLY RUN CODE LIKE CHECK FOR DATABASE UPDATES, SYNC EXTERNAL SYSTEM ETC..
        }
    }
}
