﻿CREATE TABLE [dbo].[employee](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[firstname] [varchar](100) NULL,
	[lastname] [varchar](100) NULL,
	[email] [varchar](50) NULL,
	[phone] [varchar](50) NULL,
	[rfidtag] [varchar](50) NULL,
	[companyid] [int] NOT NULL,
	[lastseen] [datetimeoffset](7) NULL,
	[locationid] [int] NULL
 CONSTRAINT [PK_employee] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE UNIQUE INDEX index_employee_id_companyid ON employee(id,companyid);

ALTER TABLE [dbo].[employee] WITH CHECK ADD CONSTRAINT [FK_employee_location] FOREIGN KEY([locationid])
REFERENCES [dbo].[location] ([id])
ON DELETE SET NULL;

CREATE VIEW [dbo].[v_employee] AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname,
	COALESCE(l.site, '') AS locationsite,
    COALESCE(l.building, '') AS locationbuilding,
    COALESCE(l.floor, '') AS locationfloor,
    COALESCE(l.room, '') AS locationroom,
    COALESCE(l.description, '') AS locationdescription
   FROM employee a
     LEFT JOIN location l ON l.id = a.locationid;

CREATE TABLE [dbo].[employeelocationhistory](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[timeseen] [datetimeoffset](7) NOT NULL,
	[timeleft] [datetimeoffset](7) NULL,
	[employeeid] [int] NOT NULL,
	[locationid] [int] NOT NULL,
	[companyid] [int] NOT NULL,
 CONSTRAINT [PK_employeelocationhistory] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE UNIQUE INDEX index_employeelocationhistory_id_companyid ON employeelocationhistory(id,companyid);

ALTER TABLE [dbo].[employeelocationhistory] WITH CHECK ADD CONSTRAINT [FK_employeelocationhistory_location] FOREIGN KEY([locationid])
REFERENCES [dbo].[location] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[employeelocationhistory] WITH CHECK ADD CONSTRAINT [FK_employeelocationhistory_employee] FOREIGN KEY([employeeid])
REFERENCES [dbo].[employee] ([id])
ON DELETE CASCADE;

CREATE VIEW [dbo].[v_employeelocationhistory] AS 
 SELECT lh.id,
    lh.timeseen,
    lh.timeleft,
    lh.employeeid,
    lh.locationid,
    lh.companyid,
    e.firstname AS employeefirstname,
	e.lastname AS employeelastname,
	e.email AS employeeemail,    
    COALESCE(l.name, 'Missing') AS locationname
   FROM employeelocationhistory lh
     LEFT JOIN location l ON l.id = lh.locationid
     LEFT JOIN employee e ON e.id = lh.employeeid;

CREATE TABLE [dbo].[scanner](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[companyname] [varchar](100) NOT NULL,
	[deviceid] [varchar](100) NULL,
	[inactive] [bit] NULL,
	[description] [varchar](500) NULL,
	[lastseen] [datetimeoffset](7) NULL DEFAULT (sysdatetimeoffset()),
 CONSTRAINT [PK_scanner] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

alter table reader add mqttcontroltopic [varchar](500) NULL;

drop view [dbo].[v_reader];

CREATE VIEW [dbo].[v_reader] AS 
 SELECT COALESCE(l.name, 'Missing') AS locationname,
    r.*
   FROM reader r
     LEFT JOIN location l ON l.id = r.locationid and l.companyid=r.companyid;

