﻿alter table maintenancehistory add regularmaintenance bit;

drop view [dbo].[v_maintenancehistory];

CREATE VIEW [dbo].[v_maintenancehistory] AS 
 SELECT mh.id,
    mh.whenperformed,
    mh.actionperformed,
    mh.notes,
    mh.performedby,
    mh.assetid,
    a.name AS assetname,
    a.description AS assetdescription
   FROM asset a,
    maintenancehistory mh
  WHERE a.id = mh.assetid;

alter table asset alter column nextmaintenance date;

drop view [dbo].[v_asset];

CREATE VIEW [dbo].[v_asset] AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname,
	COALESCE(l.site, 'Missing') AS locationsite,
    COALESCE(l.building, 'Missing') AS locationbuilding,
    COALESCE(l.floor, 'Missing') AS locationfloor,
    COALESCE(l.room, 'Missing') AS locationroom,
    COALESCE(l.description, 'Missing') AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed AND fvt.companyid=a.companyid;
