﻿DROP TRIGGER trg_company_instead_delete;

CREATE TABLE [dbo].[printclient](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[companyid] [int] NULL,
	[name] [varchar](500) NULL,
	[username] [varchar](500) NULL,
	[password] [varchar](500) NULL,
	[machinename] [varchar](500) NULL,
	[lastseen] [datetimeoffset](7) NULL,
 CONSTRAINT [PK_printclient] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE UNIQUE INDEX index_printclient_name ON printclient(name);

ALTER TABLE [dbo].[printclient]  WITH CHECK ADD CONSTRAINT [FK_printclient_company] FOREIGN KEY([companyid])
REFERENCES [dbo].[company] ([id])
ON DELETE CASCADE;

CREATE TABLE [dbo].[printclientcompany](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[printclientid] [int] NOT NULL,
	[companyid] [int] NOT NULL,
 CONSTRAINT [PK_printclientcompany] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

ALTER TABLE [dbo].[printclientcompany]  WITH CHECK ADD  CONSTRAINT [FK_printclientcompany_printclient] FOREIGN KEY([printclientid])
REFERENCES [dbo].[printclient] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[printclientcompany]  WITH CHECK ADD  CONSTRAINT [FK_printclientcompany_company] FOREIGN KEY([companyid])
REFERENCES [dbo].[company] ([id])
ON DELETE NO ACTION;

ALTER TABLE dbo.template ADD printclientid [int] NULL;

ALTER TABLE [dbo].[template]  WITH CHECK ADD CONSTRAINT [FK_template_printclient] FOREIGN KEY([printclientid])
REFERENCES [dbo].[printclient] ([id])
ON DELETE CASCADE;

ALTER TABLE dbo.serverstatus ADD servertype [varchar](500) NULL;

CREATE VIEW [dbo].[v_template] AS SELECT t.*,pc.name as printclientname FROM template t LEFT JOIN printclient pc ON pc.id=t.printclientid

alter table serverstatus alter column companyid int NULL;

alter table serverstatus drop constraint PK_serverstatus;

alter table serverstatus add [id] [int] IDENTITY(1,1) NOT NULL;

alter table serverstatus add primary key (id);