﻿ALTER TABLE dbo.locationhistory ADD timeleft datetimeoffset(7) NULL;

drop view [dbo].[v_locationhistory];

CREATE VIEW [dbo].[v_locationhistory] AS 
 SELECT lh.id,
    lh.timeseen,
    lh.timeleft,
    lh.assetid,
    lh.locationid,
    lh.companyid,
    a.name AS assetname,
    a.description AS assetdescription,
    COALESCE(l.name, 'Missing') AS locationname
   FROM locationhistory lh
     LEFT JOIN location l ON l.id = lh.locationid
     LEFT JOIN asset a ON a.id = lh.assetid;

ALTER TABLE dbo.asset ADD unseennotified bit NULL;

ALTER TABLE dbo.applicationsetting ADD enableassetunseen bit NULL;

ALTER TABLE dbo.applicationsetting ADD enableglobaleventmessages bit NULL;

ALTER TABLE dbo.applicationsetting ADD enableglobalalarmmessages bit NULL;

ALTER TABLE dbo.applicationsetting ADD enableglobalgatewaymessages bit NULL;

ALTER TABLE dbo.applicationsetting ADD enableglobalsensorreadingmessages bit NULL;

ALTER TABLE dbo.applicationsetting ADD enableglobaltagmovementmessages bit NULL;

ALTER TABLE dbo.applicationsetting ADD enableglobaltagobservationmessages bit NULL;

CREATE INDEX index_reader_physicalid_companyid ON reader(physicalid,companyid);

CREATE INDEX index_reader_usewithservice_companyid ON reader(usewithservice,companyid);

CREATE INDEX index_asset_unseen_companyid ON asset(lastobservedtime,unseennotified,maxunseentime);

CREATE UNIQUE INDEX index_fixedvtag_vtagid_companyid ON fixedvtag(vtagid,companyid);

ALTER TABLE dbo.queuedcommand ADD amsname [varchar](500) NULL;

ALTER TABLE dbo.reader ADD ipaddress [varchar](500) NULL;

ALTER TABLE dbo.reader ADD username [varchar](500) NULL;

ALTER TABLE dbo.reader ADD [password] [varchar](500) NULL;

ALTER TABLE dbo.reader ADD lastmodified [datetimeoffset](7) NULL;

update reader set ipaddress=(Select Substring(ir.portstring, 1,Charindex(',', ir.portstring)-1) as IPAddress from reader ir where ir.id=reader.id);

alter table dbo.reader drop column portstring;

CREATE INDEX index_queuedcommand_status_companyid_amsname ON queuedcommand(status,companyid,amsname);

CREATE INDEX index_queuedcommand_readerid_companyid ON queuedcommand(companyid,readerid);

DROP TRIGGER trg_alarmack_after_delete;

DROP TRIGGER trg_alarmack_after_update;

DROP TRIGGER trg_alertingaction_after_insert;

DROP TRIGGER trg_alertingaction_after_update;

DROP TRIGGER trg_alertingaction_instead_delete;

DROP TRIGGER trg_applicationsetting_after_update;

DROP TRIGGER trg_antenna_after_update;

DROP TRIGGER trg_antenna_after_delete;

DROP TRIGGER trg_antenna_after_insert;

DROP TRIGGER trg_plugin_after_update;

DROP TRIGGER trg_plugin_after_delete;

DROP TRIGGER trg_plugin_after_insert;

DROP TRIGGER trg_asset_after_insert;

DROP TRIGGER trg_asset_after_update;

DROP TRIGGER trg_asset_after_delete;

DROP TRIGGER trg_fixedvtag_after_update;

DROP TRIGGER trg_fixedvtag_after_insert;

DROP TRIGGER trg_fixedvtag_after_delete;

DROP TRIGGER trg_location_after_insert;

DROP TRIGGER trg_location_after_update;

DROP TRIGGER trg_location_instead_delete;

DROP TRIGGER trg_reader_after_insert;

DROP TRIGGER trg_reader_after_update;

DROP TRIGGER trg_reader_instead_delete;

drop view [dbo].[v_reader];

CREATE VIEW [dbo].[v_reader] AS 
 SELECT COALESCE(l.name, 'Missing') AS locationname,
    r.*
   FROM reader r
     LEFT JOIN location l ON l.id = r.locationid and l.companyid=r.companyid;

drop view [dbo].[v_asset];

CREATE VIEW [dbo].[v_asset] AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname,
	COALESCE(l.site, 'Missing') AS locationsite,
    COALESCE(l.building, 'Missing') AS locationbuilding,
    COALESCE(l.floor, 'Missing') AS locationfloor,
    COALESCE(l.room, 'Missing') AS locationroom,
    COALESCE(l.description, 'Missing') AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed AND fvt.companyid=a.companyid;

CREATE TABLE [dbo].[mqttclient](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[companyid] [int] NOT NULL,
	[username] [varchar](500) NULL,
	[password] [varchar](500) NULL,
	[accessgatewaymessages] bit NULL,
	[accesstagmovements] bit NULL,
	[accesstagobservations] bit NULL,
	[accessevents] bit NULL,
	[accessalarms] bit NULL,
	[accessvtagsensors] bit NULL
 CONSTRAINT [pk_mqttclient] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

drop table configurationchange;