﻿CREATE TABLE [dbo].[company](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NULL,
 CONSTRAINT [pk_company] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

INSERT INTO company (name) values ('My Company');

ALTER TABLE asset ADD [companyid] [int] NULL;

UPDATE ASSET SET companyid=(select id from company);

ALTER TABLE asset ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_asset_id_companyid ON asset(id,companyid);

ALTER TABLE alarm ADD [companyid] [int] NULL;

UPDATE alarm SET companyid=(select id from company);

ALTER TABLE alarm ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_alarm_id_companyid ON alarm(id,companyid);

ALTER TABLE alarmack ADD [companyid] [int] NULL;

UPDATE alarmack SET companyid=(select id from company);

ALTER TABLE alarmack ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_alarmack_id_companyid ON alarmack(id,companyid);

ALTER TABLE alertingaction ADD [companyid] [int] NULL;

UPDATE alertingaction SET companyid=(select id from company);

ALTER TABLE alertingaction ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_alertingaction_id_companyid ON alertingaction(id,companyid);

ALTER TABLE antenna ADD [companyid] [int] NULL;

UPDATE antenna SET companyid=(select id from company);

ALTER TABLE antenna ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_antenna_id_companyid ON antenna(id,companyid);

ALTER TABLE checkouthistory ADD [companyid] [int] NULL;

UPDATE checkouthistory SET companyid=(select id from company);

ALTER TABLE checkouthistory ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_checkouthistory_id_companyid ON checkouthistory(id,companyid);

ALTER TABLE clientapp ADD [companyid] [int] NULL;

UPDATE clientapp SET companyid=(select id from company);

ALTER TABLE clientapp ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_clientapp_id_companyid ON checkouthistory(id,companyid);

TRUNCATE TABLE configurationchange;

ALTER TABLE configurationchange ADD [companyid] [int];

ALTER TABLE [event] ADD [companyid] [int] NULL;

UPDATE [event] SET companyid=(select id from company);

ALTER TABLE [event] ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_event_id_companyid ON [event](id,companyid);

ALTER TABLE filedata ADD [companyid] [int] NULL;

UPDATE filedata SET companyid=(select id from company);

ALTER TABLE filedata ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_filedata_id_companyid ON filedata(id,companyid);

ALTER TABLE fixedvtag ADD [companyid] [int] NULL;

UPDATE fixedvtag SET companyid=(select id from company);

ALTER TABLE fixedvtag ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_fixedvtag_id_companyid ON fixedvtag(id,companyid);

ALTER TABLE gpslocationhistory ADD [companyid] [int] NULL;

UPDATE gpslocationhistory SET companyid=(select id from company);

ALTER TABLE gpslocationhistory ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_gpslocationhistory_id_companyid ON gpslocationhistory(id,companyid);

ALTER TABLE location ADD [companyid] [int] NULL;

UPDATE location SET companyid=(select id from company);

ALTER TABLE location ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_location_id_companyid ON location(id,companyid);

ALTER TABLE locationhistory ADD [companyid] [int] NULL;

UPDATE locationhistory SET companyid=(select id from company);

ALTER TABLE locationhistory ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_locationhistory_id_companyid ON locationhistory(id,companyid);

ALTER TABLE maintenancehistory ADD [companyid] [int] NULL;

UPDATE maintenancehistory SET companyid=(select id from company);

ALTER TABLE maintenancehistory ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_maintenancehistory_id_companyid ON maintenancehistory(id,companyid);

ALTER TABLE maparea ADD [companyid] [int] NULL;

UPDATE maparea SET companyid=(select id from company);

ALTER TABLE maparea ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_maparea_id_companyid ON maparea(id,companyid);

ALTER TABLE mapsite ADD [companyid] [int] NULL;

UPDATE mapsite SET companyid=(select id from company);

ALTER TABLE mapsite ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_mapsite_id_companyid ON mapsite(id,companyid);

ALTER TABLE plugin ADD [companyid] [int] NULL;

UPDATE plugin SET companyid=(select id from company);

ALTER TABLE plugin ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_plugin_id_companyid ON plugin(id,companyid);

ALTER TABLE printjob ADD [companyid] [int] NULL;

UPDATE printjob SET companyid=(select id from company);

ALTER TABLE printjob ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_printjob_id_companyid ON printjob(id,companyid);

ALTER TABLE queuedcommand ADD [companyid] [int] NULL;

UPDATE queuedcommand SET companyid=(select id from company);

ALTER TABLE queuedcommand ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_queuedcommand_id_companyid ON queuedcommand(id,companyid);

ALTER TABLE reader ADD [companyid] [int] NULL;

UPDATE reader SET companyid=(select id from company);

ALTER TABLE reader ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_reader_id_companyid ON reader(id,companyid);

ALTER TABLE sensorreading ADD [companyid] [int] NULL;

UPDATE sensorreading SET companyid=(select id from company);

ALTER TABLE sensorreading ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_sensorreading_id_companyid ON sensorreading(id,companyid);

ALTER TABLE sensorstat ADD [companyid] [int] NULL;

UPDATE sensorstat SET companyid=(select id from company);

ALTER TABLE sensorstat ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_sensorstat_id_companyid ON sensorstat(id,companyid);

ALTER TABLE serverstatus ADD [companyid] [int] NULL;

UPDATE serverstatus SET companyid=(select id from company);

ALTER TABLE serverstatus ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_serverstatus_id_companyid ON serverstatus(name,companyid);

ALTER TABLE sysuser ADD [companyid] [int] NULL;

UPDATE sysuser SET companyid=(select id from company);

ALTER TABLE template ADD [companyid] [int] NULL;

UPDATE template SET companyid=(select id from company);

ALTER TABLE template ALTER COLUMN companyid [int] NOT NULL;

CREATE UNIQUE INDEX index_template_id_companyid ON template(name,companyid);

DROP TRIGGER trg_alarmack_after_delete;

CREATE TRIGGER trg_alarmack_after_delete
ON dbo.alarmack
AFTER DELETE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'alarmack', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

DROP TRIGGER trg_alarmack_after_update;

CREATE TRIGGER trg_alarmack_after_update
ON dbo.alarmack
AFTER UPDATE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'alarmack', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

DROP TRIGGER trg_alertingaction_after_insert;

CREATE TRIGGER trg_alertingaction_after_insert
ON dbo.alertingaction
AFTER INSERT 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'alertingaction', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

DROP TRIGGER trg_alertingaction_after_update;

CREATE TRIGGER trg_alertingaction_after_update
ON dbo.alertingaction
AFTER UPDATE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'alertingaction', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

DROP TRIGGER trg_alertingaction_instead_delete;

CREATE TRIGGER trg_alertingaction_instead_delete
ON alertingaction
INSTEAD OF DELETE 
AS
BEGIN
	UPDATE asset SET asset.lastmodifiedby='db_default', asset.alertingactionid=null from asset INNER JOIN Deleted d on asset.alertingactionid=d.id;    		
	UPDATE r SET r.lastmodifiedby='db_default' from reader r INNER JOIN Deleted d on 
		r.assetmovedalertingactionid=d.id OR r.lowbatteryalertingactionid=d.id OR r.sensorthresholdalertingactionid=d.id OR r.innerdirectionalertingactionid=d.id
		OR r.outerdirectionalertingactionid=d.id OR r.readerdisconnectedalertingactionid=d.id;
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby) SELECT d.companyid, 'alertingaction', 'Delete', d.id, 'db_trigger' FROM Deleted d;
	DELETE a from antenna as a INNER JOIN deleted as d on a.alertingactionid=d.id;	
	DELETE aa from alertingaction as aa INNER JOIN deleted as d on aa.id=d.id;
END

DROP TRIGGER trg_applicationsetting_after_update;

CREATE TRIGGER trg_applicationsetting_after_update
ON dbo.applicationsetting
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'applicationsetting', 'Edit', d.id, 'db_trigger'
        FROM inserted d;

DROP TRIGGER trg_antenna_after_update;

CREATE TRIGGER trg_antenna_after_update
ON dbo.antenna
AFTER UPDATE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'antenna', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

DROP TRIGGER trg_antenna_after_delete;

CREATE TRIGGER trg_antenna_after_delete
ON dbo.antenna
AFTER DELETE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'antenna', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

DROP TRIGGER trg_antenna_after_insert;

CREATE TRIGGER trg_antenna_after_insert
ON dbo.antenna
AFTER INSERT 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'antenna', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

DROP TRIGGER trg_plugin_after_update;

CREATE TRIGGER trg_plugin_after_update
ON dbo.plugin
AFTER UPDATE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'plugin', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

DROP TRIGGER trg_plugin_after_delete;

CREATE TRIGGER trg_plugin_after_delete
ON dbo.plugin
AFTER DELETE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'plugin', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

DROP TRIGGER trg_plugin_after_insert;

CREATE TRIGGER trg_plugin_after_insert
ON dbo.plugin
AFTER INSERT 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'plugin', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

DROP TRIGGER trg_asset_after_insert;

CREATE TRIGGER trg_asset_after_insert
ON dbo.asset
AFTER INSERT 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'asset', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

DROP TRIGGER trg_asset_after_update;

CREATE TRIGGER trg_asset_after_update
ON dbo.asset
AFTER UPDATE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'asset', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

DROP TRIGGER trg_asset_after_delete;

CREATE TRIGGER trg_asset_after_delete
ON dbo.asset
AFTER DELETE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'asset', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

DROP TRIGGER trg_fixedvtag_after_update;

CREATE TRIGGER trg_fixedvtag_after_update
ON dbo.fixedvtag
AFTER UPDATE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'fixedvtag', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

DROP TRIGGER trg_fixedvtag_after_insert;

CREATE TRIGGER trg_fixedvtag_after_insert
ON dbo.fixedvtag
AFTER INSERT 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'fixedvtag', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

DROP TRIGGER trg_fixedvtag_after_delete;

CREATE TRIGGER trg_fixedvtag_after_delete
ON dbo.fixedvtag
AFTER DELETE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'fixedvtag', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

DROP TRIGGER trg_location_after_insert;

CREATE TRIGGER trg_location_after_insert
ON dbo.location
AFTER INSERT 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'location', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

DROP TRIGGER trg_location_after_update;

CREATE TRIGGER trg_location_after_update
ON dbo.location
AFTER UPDATE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'location', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

DROP TRIGGER trg_location_instead_delete;

CREATE TRIGGER trg_location_instead_delete
ON location
INSTEAD OF DELETE 
AS
BEGIN
	UPDATE asset SET asset.lastmodifiedby='db_default', asset.locationid=null from asset INNER JOIN Deleted d on asset.locationid=d.id;    
	UPDATE t SET t.lastmodifiedby='db_default', t.locationid=null from fixedvtag t INNER JOIN Deleted d on t.locationid=d.id;    
	UPDATE t SET t.lastmodifiedby='db_default', t.locationid=null from reader t INNER JOIN Deleted d on t.locationid=d.id;    
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby) SELECT d.companyid, 'location', 'Delete', d.id, 'db_trigger' FROM Deleted d;
	DELETE a from antenna as a INNER JOIN deleted as d on a.locationid=d.id;
	DELETE lh from locationhistory as lh INNER JOIN deleted as d on lh.locationid=d.id;	
	DELETE l from location as l INNER JOIN deleted as d on l.id=d.id;
END

DROP TRIGGER trg_reader_after_insert;

CREATE TRIGGER trg_reader_after_insert
ON dbo.reader
AFTER INSERT 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'reader', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

DROP TRIGGER trg_reader_after_update;

CREATE TRIGGER trg_reader_after_update
ON dbo.reader
AFTER UPDATE 
AS
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby)
        SELECT d.companyid, 'reader', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

DROP TRIGGER trg_reader_instead_delete;

CREATE TRIGGER trg_reader_instead_delete
ON reader
INSTEAD OF DELETE 
AS
BEGIN
	UPDATE asset SET asset.lastmodifiedby='db_default', asset.readerid=null from asset INNER JOIN Deleted d on asset.readerid=d.id;    		
	UPDATE fixedvtag SET fixedvtag.lastmodifiedby='db_default', fixedvtag.readerid=null from fixedvtag INNER JOIN Deleted d on fixedvtag.readerid=d.id;    		
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby) SELECT d.companyid, 'reader', 'Delete', d.id, 'db_trigger' FROM Deleted d;
	DELETE qq from queuedcommand as qq INNER JOIN deleted as d on qq.readerid=d.id;	
	DELETE a from antenna as a INNER JOIN deleted as d on a.readerid=d.id;	
	DELETE r from reader as r INNER JOIN deleted as d on r.id=d.id;
END

CREATE TRIGGER trg_company_instead_delete
ON company
INSTEAD OF DELETE 
AS
BEGIN    
    DELETE tabl from alarm as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from alarmack as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from alertingaction as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from antenna as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from asset as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from checkouthistory as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from clientapp as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from configurationchange as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from [event] as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from filedata as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from fixedvtag as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from gpslocationhistory as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from location as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from locationhistory as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from maintenancehistory as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from maparea as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from mapsite as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from plugin as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from printjob as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from queuedcommand as tabl INNER JOIN deleted as d on tabl.companyid=d.id;
    DELETE tabl from reader as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from sensorreading as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from sensorstat as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from serverstatus as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from sysuser as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from template as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    DELETE tabl from configurationchange as tabl INNER JOIN deleted as d on tabl.companyid=d.id;	
    INSERT INTO configurationchange(companyid,modifiedtable,changeevent,recordid,madeby) SELECT d.id, 'company', 'Delete', d.id, 'db_trigger' FROM Deleted d;
    delete tabl from company as tabl INNER JOIN deleted as d on tabl.id=d.id;
END

drop view [dbo].[v_asset];

CREATE VIEW [dbo].[v_asset] AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname,
	COALESCE(l.site, 'Missing') AS locationsite,
    COALESCE(l.building, 'Missing') AS locationbuilding,
    COALESCE(l.floor, 'Missing') AS locationfloor,
    COALESCE(l.room, 'Missing') AS locationroom,
    COALESCE(l.description, 'Missing') AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed AND fvt.companyid=a.companyid;


drop view [dbo].[v_assetvtag];

CREATE VIEW [dbo].[v_assetvtag] AS 
  SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname,
	COALESCE(l.site, 'Missing') AS locationsite,
    COALESCE(l.building, 'Missing') AS locationbuilding,
    COALESCE(l.floor, 'Missing') AS locationfloor,
    COALESCE(l.room, 'Missing') AS locationroom,
    COALESCE(l.description, 'Missing') AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed AND fvt.companyid=a.companyid
  WHERE NOT a.vtagid IS NULL;

drop view [dbo].[v_sensorreading];

CREATE VIEW [dbo].[v_sensorreading] AS
select sr.id,sr.vtagid,sr.name,sr.created,sr.sourcedistancehops,sr.ttl,sr.minimumhumiditypercent,sr.maximumhumiditypercent,sr.batteryvolts,sr.z,sr.locationconfidence,sr.maximumaccelerationg,sr.maximumlightlevellux, sr.companyid,
CASE WHEN appSetting.UseMeters=1 THEN x ELSE ROUND(convert(decimal(18,2), x * 3.28), 2) END AS x,
CASE WHEN appSetting.UseMeters=1 THEN y ELSE ROUND(y * 3.28, 2) END AS y,
CASE WHEN appSetting.TemperatureFormat='Fahrenheit' THEN ROUND(convert(decimal(18,2),minimumtemperaturedegc * 9 / 5 + 32), 2) ELSE minimumtemperaturedegc END AS minimumtemperaturedegc,
CASE WHEN appSetting.TemperatureFormat='Fahrenheit' THEN ROUND(convert(decimal(18,2),maximumtemperaturedegc * 9 / 5 + 32), 2) ELSE maximumtemperaturedegc END AS maximumtemperaturedegc
from sensorreading sr CROSS JOIN applicationsetting AS appSetting

drop view [dbo].[vtag];

CREATE VIEW [dbo].[vtag] AS
select vtagid,vtagx,vtagy,vtagz,vtagpositiontype,vtaglastseen,batterylevel,readerid from asset
union
select vtagid,vtagx,vtagy,vtagz,vtagpositiontype,vtaglastseen,batterylevel,readerid from fixedvtag;

drop view [dbo].[v_batterylevel];

CREATE VIEW [dbo].[v_batterylevel] AS 
 SELECT a.name AS assetname,
    vt.vtagid,
    vt.vtagx,
    vt.vtagy,
    vt.vtagz,
    vt.vtagpositiontype,
    vt.vtaglastseen,
    vt.batterylevel
   FROM vtag vt
     LEFT JOIN asset a ON a.vtagid = vt.vtagid;

drop view [dbo].[v_vtag];

CREATE VIEW [dbo].[v_vtag] AS 
 SELECT vtag.vtagid,
    vtag.vtagx,
    vtag.vtagy,
    vtag.vtagz,
    vtag.vtagpositiontype,
    vtag.vtaglastseen,
    vtag.batterylevel,
    vtag.readerid
   FROM vtag
  WHERE NOT vtag.vtagid IS NULL;

drop view [dbo].[v_checkouthistory];

CREATE VIEW [dbo].[v_checkouthistory] AS 
 SELECT a.name AS assetname,
    ch.id,
    ch.checkinstatus,
    ch.individual,
    ch.transactiontime,
    ch.assetid
   FROM asset a,
    checkouthistory ch
  WHERE a.id = ch.assetid;

drop view [dbo].[v_fixedvtag];

CREATE VIEW [dbo].[v_fixedvtag] AS 
 SELECT COALESCE(l.name, 'Missing') AS locationname,
    r.name AS readername,
    vt.*
   FROM fixedvtag vt
     LEFT JOIN location l ON l.id = vt.locationid
     LEFT JOIN reader r ON r.id = vt.readerid;

drop view [dbo].[v_locationhistory];

CREATE VIEW [dbo].[v_locationhistory] AS 
 SELECT lh.id,
    lh.timeseen,
    lh.assetid,
    lh.locationid,
    lh.companyid,
    a.name AS assetname,
    a.description AS assetdescription,
    COALESCE(l.name, 'Missing') AS locationname
   FROM locationhistory lh
     LEFT JOIN location l ON l.id = lh.locationid
     LEFT JOIN asset a ON a.id = lh.assetid;

drop view [dbo].[v_maintenancehistory];

CREATE VIEW [dbo].[v_maintenancehistory] AS 
 SELECT mh.id,
    mh.whenperformed,
    mh.actionperformed,
    mh.notes,
    mh.performedby,
    mh.assetid,
    a.name AS assetname,
    a.description AS assetdescription
   FROM asset a,
    maintenancehistory mh
  WHERE a.id = mh.assetid;

drop view [dbo].[v_site];

CREATE VIEW [dbo].[v_site] AS 
 SELECT DISTINCT location.site
   FROM location
  WHERE NOT location.site is NULL;

drop view [dbo].[v_gpslocationhistory];

CREATE VIEW [dbo].[v_gpslocationhistory] AS 
 SELECT glh.id,
    glh.timeseen,
    glh.movement,
    glh.latitude,
    glh.longitude,
    glh.assetid,
    a.name AS assetname,
    a.description AS assetdescription
   FROM gpslocationhistory glh
     LEFT JOIN asset a ON a.id = glh.assetid;

CREATE VIEW [dbo].[v_sysuser] AS 
 SELECT s.*,
    COALESCE(c.name, '') AS companyname
   FROM sysuser s
     LEFT JOIN company c ON c.id = s.companyid
