﻿ALTER TABLE [dbo].[asset] ADD lastmaintenance [datetimeoffset](7) NULL;

drop view [dbo].[v_asset];

CREATE VIEW [dbo].[v_asset] AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname,
	COALESCE(l.site, 'Missing') AS locationsite,
    COALESCE(l.building, 'Missing') AS locationbuilding,
    COALESCE(l.floor, 'Missing') AS locationfloor,
    COALESCE(l.room, 'Missing') AS locationroom,
    COALESCE(l.description, 'Missing') AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed;


drop view [dbo].[v_assetvtag];

CREATE VIEW [dbo].[v_assetvtag] AS 
  SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname,
	COALESCE(l.site, 'Missing') AS locationsite,
    COALESCE(l.building, 'Missing') AS locationbuilding,
    COALESCE(l.floor, 'Missing') AS locationfloor,
    COALESCE(l.room, 'Missing') AS locationroom,
    COALESCE(l.description, 'Missing') AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed
  WHERE NOT a.vtagid IS NULL;
