﻿CREATE TABLE [dbo].[gpslocationhistory](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[timeseen] [datetimeoffset](7) NOT NULL,
	[assetid] [int] NOT NULL,
	[movement] [bit] NULL,
	latitude [decimal](18, 0) NOT NULL,
	longitude [decimal](18, 0) NOT NULL,
CONSTRAINT [PK_gpslocationhistory] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

ALTER TABLE [dbo].[gpslocationhistory] ADD  CONSTRAINT [DF_gpslocationhistory_timeseen]  DEFAULT (sysdatetimeoffset()) FOR [timeseen];

ALTER TABLE [dbo].[gpslocationhistory]  WITH CHECK ADD  CONSTRAINT [FK_gpslocationhistory_asset] FOREIGN KEY([assetid])
REFERENCES [dbo].[asset] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[gpslocationhistory] CHECK CONSTRAINT [FK_gpslocationhistory_asset];

CREATE TABLE [dbo].[clientapp](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[clientid] [varchar](500) NOT NULL,
	[granttype] [varchar](50) NULL,
	[secret] [varchar](5000) NULL,
	[allowRefreshTokens] bit NULL,
	CONSTRAINT [PK_clientapp] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

DROP TRIGGER [dbo].[trg_locationhistory_after_insert];

ALTER TABLE dbo.applicationsetting ADD twofactorauthenabled [bit] NULL;

ALTER TABLE dbo.applicationsetting ADD authenticationserver [varchar](5000) NULL;

ALTER TABLE dbo.applicationsetting ADD emailmethod [varchar](100) NULL;

ALTER TABLE dbo.applicationsetting ADD emailcloudusername [varchar](200) NULL;

ALTER TABLE dbo.applicationsetting ADD emailcloudpassword [varchar](500) NULL;

ALTER TABLE dbo.sysuser ADD verificationcode [varchar](50) NULL;

ALTER TABLE dbo.sysuser ADD verificationcodecreated [datetimeoffset](7) NULL;

ALTER TABLE dbo.sysuser ADD verificationcodeattempts integer NULL;

ALTER TABLE dbo.session ADD staysignedin bit;