﻿ALTER TABLE [dbo].[asset] ADD latitude [decimal](18, 0) NULL, longitude [decimal](18, 0) NULL, altitude [decimal](18, 0) NULL,numberofsatellites [int] NULL, gpsaccuracy [int] NULL, lastgpsfix [datetimeoffset](7) NULL,vtagtype [varchar](50) NULL,parentvtag [varchar](50) NULL;

ALTER TABLE [dbo].[sensorreading] ADD latitude [decimal](18, 0) NULL, longitude [decimal](18, 0) NULL, altitude [decimal](18, 0) NULL,numberofsatellites [int] NULL, gpsaccuracy [int] NULL, lastgpsfix [datetimeoffset](7) NULL,vtagtype [varchar](50) NULL, nearestfixed [varchar](50) NULL,parentvtag [varchar](50) NULL;

ALTER TABLE [dbo].[fixedvtag] ADD vtagtype [varchar](50) NULL;

ALTER TABLE [dbo].[applicationsetting] ADD dateformat [varchar](50) NULL;

ALTER TABLE [dbo].[maparea] ADD geo1latitude [decimal](18, 0) NULL, geo1longitude [decimal](18, 0) NULL, geo1pixelsx [decimal](18, 0) NULL,geo1pixelsy [decimal](18, 0) NULL,geo2latitude [decimal](18, 0) NULL, geo2longitude [decimal](18, 0) NULL, geo2pixelsx [decimal](18, 0) NULL, geo2pixelsy [decimal](18, 0) NULL;

drop view [dbo].[v_asset];

CREATE VIEW [dbo].[v_asset] AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid;

drop view [dbo].[v_assetvtag];

CREATE VIEW [dbo].[v_assetvtag] AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
  WHERE NOT a.vtagid IS NULL;

drop view [dbo].[v_fixedvtag];

CREATE VIEW [dbo].[v_fixedvtag] AS 
 SELECT COALESCE(l.name, 'Missing') AS locationname,
    r.name AS readername,
    vt.*
   FROM fixedvtag vt
     LEFT JOIN location l ON l.id = vt.locationid
     LEFT JOIN reader r ON r.id = vt.readerid;

drop view [dbo].[v_sensorreading];

CREATE VIEW [dbo].[v_sensorreading] AS
select sr.id,sr.vtagid,sr.name,sr.created,sr.sourcedistancehops,sr.ttl,sr.minimumhumiditypercent,sr.maximumhumiditypercent,sr.batteryvolts,sr.z,sr.locationconfidence,sr.maximumaccelerationg,sr.maximumlightlevellux,sr.latitude,sr.longitude,sr.altitude,sr.numberofsatellites,sr.lastgpsfix,sr.vtagtype,sr.gpsaccuracy,sr.parentvtag,
CASE WHEN appSetting.UseMeters=1 THEN x ELSE ROUND(convert(decimal(18,2), x * 3.28), 2) END AS x,
CASE WHEN appSetting.UseMeters=1 THEN y ELSE ROUND(y * 3.28, 2) END AS y,
CASE WHEN appSetting.TemperatureFormat='Fahrenheit' THEN ROUND(convert(decimal(18,2),minimumtemperaturedegc * 9 / 5 + 32), 2) ELSE minimumtemperaturedegc END AS minimumtemperaturedegc,
CASE WHEN appSetting.TemperatureFormat='Fahrenheit' THEN ROUND(convert(decimal(18,2),maximumtemperaturedegc * 9 / 5 + 32), 2) ELSE maximumtemperaturedegc END AS maximumtemperaturedegc
from sensorreading sr CROSS JOIN applicationsetting AS appSetting
