﻿CREATE TABLE [dbo].[alarm](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[alarmtime] [datetimeoffset](7) NULL,
	[rfidtag] [varchar](50) NULL,
	[readername] [varchar](50) NULL,
	[readerlocation] [varchar](50) NULL,
	[assetname] [varchar](50) NULL,
	[assetdescription] [varchar](100) NULL,
	[alertingactionname] [varchar](50) NULL,
	[eventtype] [varchar](50) NULL,
	[thresholdtype] [varchar](50) NULL,
	[eventdetails] [varchar](500) NULL,
	[antennanumber] [varchar](50) NULL,
	[rssi] [varchar](50) NULL,
	[popuprequested] [bit] NULL,
	[vtagid] [varchar](50) NULL,
	[lastmodifiedby] [varchar](50) NULL,
 CONSTRAINT [PK_alarm] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[alarmack](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NULL,
	[tag] [varchar](50) NULL,
	[eventtype] [varchar](50) NULL,
	[thresholdtype] [varchar](50) NULL,
	[assetname] [varchar](50) NULL,
	[assetdescription] [varchar](500) NULL,
	[acktime] [datetimeoffset](7) NULL CONSTRAINT [DF_alarmack_acktime]  DEFAULT (sysdatetimeoffset()),
	[lastmodifiedby] [varchar](50) NULL,
 CONSTRAINT [PK_alarmack] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[alertingaction](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NULL,
	[adminpopupalert] [bit] NULL,
	[checkin] [bit] NULL,
	[checkout] [bit] NULL,
	[logalarm] [bit] NULL,
	[onlyifcheckedin] [bit] NULL,
	[autoack] [bit] NULL,
	[pluginactions] [varchar](50) NULL,
	[changelocation] [bit] NULL,
	[smtpemail] [bit] NULL,
	[gpo1] [bit] NULL,
	[gpo1state] [varchar](50) NULL,
	[gpo1seconds] [int] NULL,
	[gpo2] [bit] NULL,
	[gpo2state] [varchar](50) NULL,
	[gpo2seconds] [int] NULL,
	[lastmodifiedby] [varchar](50) NULL,
 CONSTRAINT [PK_alertingaction] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[antenna](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[alertingactionid] [int] NULL,
	[locationid] [int] NULL,
	[readerid] [int] NULL,
	[number] [int] NULL,
	[lastmodifiedby] [varchar](50) NULL,
 CONSTRAINT [PK_antenna] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[applicationsetting](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[version] [varchar](50) NULL,
	[type] [varchar](1000) NULL,
	[licensekey] [varchar](1000) NULL,
	[company] [varchar](50) NULL,
	[lastrfidserialnumber] [int] NOT NULL CONSTRAINT [DF_applicationsetting_lastrfidserialnumber]  DEFAULT ((1)),
	[temperatureformat] [varchar](50) NULL CONSTRAINT [DF_applicationsetting_temperatureformat]  DEFAULT ('Fahrenheit'),
	[lastmodifiedby] [varchar](50) NULL,
	[usemeters] [bit] NULL CONSTRAINT [DF_applicationsetting_usemeters]  DEFAULT ((0)),
	[assetdisplaycolumns] [varchar](5000) NULL CONSTRAINT [DF_applicationsetting_assetdisplaycolumns]  DEFAULT ('name,vTagID,rfidTag,locationName,description,created'),
	[vtagpopupdisplayrows] [varchar](5000) NULL CONSTRAINT [DF_applicationsetting_vtagpopupdisplayrows]  DEFAULT ('name,vTagID,vTagLastSeen,batteryLevel,description'),
	[cmdmaprefresh] [int] NULL CONSTRAINT [DF_applicationsetting_cmdmaprefresh]  DEFAULT ((15)),
	[cmdactivetimeout] [int] NULL CONSTRAINT [DF_applicationsetting_cmdactivetimeout]  DEFAULT ((75)),
	[eventtrim] [int] NULL CONSTRAINT [DF_applicationsetting_eventtrim]  DEFAULT ((7)),
	[alarmtrim] [int] NULL CONSTRAINT [DF_applicationsetting_alarmtrim]  DEFAULT ((30)),
	[sensorreadingtrim] [int] NULL CONSTRAINT [DF_applicationsetting_sensorreadingtrim]  DEFAULT ((30)),
	[locationhistorytrim] [int] NULL CONSTRAINT [DF_applicationsetting_locationhistorytrim]  DEFAULT ((90)),
	[commandtrim] [int] NULL CONSTRAINT [DF_applicationsetting_commandtrim]  DEFAULT ((365)),
	[sensorstattrim] [int] NULL CONSTRAINT [DF_applicationsetting_sensorstattrim]  DEFAULT ((30)),
	[smtpemailenablessl] [bit] NULL CONSTRAINT [DF_applicationsetting_smtpemailenablessl]  DEFAULT ((0)),
	[smtpemailfrom] [varchar](5000) NULL,
	[smtpemailhost] [varchar](5000) NULL,
	[smtpemailpassword] [varchar](5000) NULL,
	[smtpemailport] [int] NULL CONSTRAINT [DF_applicationsetting_smtpemailport]  DEFAULT ((25)),
	[smtpemailto] [varchar](5000) NULL,
	[smtpemailusername] [varchar](5000) NULL,
 CONSTRAINT [PK_applicationsetting] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[asset](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NOT NULL,
	[description] [varchar](500) NULL,
	[rfidtag] [varchar](50) NULL,
	[assettype] [varchar](50) NULL,
	[departmentcode] [varchar](50) NULL,
	[maxunseentime] [int] NULL,
	[lastobservedlocation] [varchar](50) NULL,
	[lastobservedtime] [datetimeoffset](7) NULL CONSTRAINT [DF_asset_lastobservedtime]  DEFAULT (sysdatetimeoffset()),
	[checkinstatus] [varchar](50) NULL,
	[checkedoutto] [varchar](50) NULL,
	[additionalinformation] [varchar](5000) NULL,
	[disposalstatus] [varchar](50) NULL CONSTRAINT [DF_asset_disposalstatus]  DEFAULT ('In Service'),
	[disposalmethod] [varchar](50) NULL,
	[disposaldate] [datetimeoffset](7) NULL,
	[disposaldestination] [varchar](50) NULL,
	[maintenancestartdate] [datetimeoffset](7) NULL,
	[maintenancesingledate] [datetimeoffset](7) NULL,
	[nextmaintenance] [datetimeoffset](7) NULL,
	[date1] [datetimeoffset](7) NULL,
	[date2] [datetimeoffset](7) NULL,
	[date3] [datetimeoffset](7) NULL,
	[date4] [datetimeoffset](7) NULL,
	[date5] [datetimeoffset](7) NULL,
	[listvalue1] [varchar](100) NULL,
	[listvalue2] [varchar](100) NULL,
	[listvalue3] [varchar](100) NULL,
	[listvalue4] [varchar](100) NULL,
	[listvalue5] [varchar](100) NULL,
	[text1] [varchar](500) NULL,
	[text2] [varchar](500) NULL,
	[text3] [varchar](500) NULL,
	[text4] [varchar](500) NULL,
	[text5] [varchar](500) NULL,
	[text6] [varchar](500) NULL,
	[text7] [varchar](500) NULL,
	[text8] [varchar](500) NULL,
	[text9] [varchar](500) NULL,
	[text10] [varchar](500) NULL,
	[text11] [varchar](500) NULL,
	[text12] [varchar](500) NULL,
	[text13] [varchar](500) NULL,
	[text14] [varchar](500) NULL,
	[text15] [varchar](500) NULL,
	[text16] [varchar](500) NULL,
	[text17] [varchar](500) NULL,
	[text18] [varchar](500) NULL,
	[text19] [varchar](500) NULL,
	[text20] [varchar](500) NULL,
	[maintenancemethod] [varchar](50) NULL,
	[maintenanceintervalmonths] [int] NULL,
	[nearestfixed] [varchar](50) NULL,
	[lastmodified] [datetimeoffset](7) NULL CONSTRAINT [DF_asset_lastmodified]  DEFAULT (sysdatetimeoffset()),
	[locationid] [int] NULL,
	[sensorreadinghistoryid] [int] NULL,
	[alertingactionid] [int] NULL,
	[sensorstatshistoryid] [int] NULL,
	[readerid] [int] NULL,
	[assetparentid] [int] NULL,
	[assetchildcount] [int] NULL,
	[vtagboxx] [decimal](18, 0) NULL,
	[vtagboxy] [decimal](18, 0) NULL,
	[vtagboxwidth] [decimal](18, 0) NULL,
	[vtagboxheight] [decimal](18, 0) NULL,
	[vtagx] [decimal](18, 0) NULL,
	[vtagy] [decimal](18, 0) NULL,
	[vtagaccelsensor] [bit] NULL,
	[vtagpositiontype] [varchar](50) NULL,
	[vtagalgorithmtype] [varchar](50) NULL,
	[batterylevel] [decimal](18, 0) NULL,
	[vtagid] [varchar](50) NULL,
	[vtagz] [int] NULL,
	[vtaglastseen] [datetimeoffset](7) NULL,
	[vtaglastmoved] [datetimeoffset](7) NULL,
	[filedataid] [int] NULL,
	[created] [datetimeoffset](7) NULL CONSTRAINT [DF_asset_created]  DEFAULT (sysdatetimeoffset()),
	[lastmodifiedby] [varchar](50) NULL,
 CONSTRAINT [PK_asset] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[changelog](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[tablename] [varchar](50) NULL,
	[recordid] [int] NULL,
	[changetype] [varchar](50) NULL,
	[changedate] [datetimeoffset](7) NULL,
	[changedby] [varchar](50) NULL,
 CONSTRAINT [PK_changelog] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[checkouthistory](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[checkinstatus] [varchar](50) NULL,
	[individual] [varchar](50) NULL,
	[transactiontime] [datetimeoffset](7) NULL,
	[assetid] [int] NOT NULL,
 CONSTRAINT [PK_checkouthistory] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[configurationchange](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[modifiedtable] [varchar](50) NOT NULL,
	[changeevent] [varchar](50) NOT NULL,
	[recordid] [int] NOT NULL,
	[created] [datetimeoffset](7) NOT NULL CONSTRAINT [DF_configurationchange_created]  DEFAULT (sysdatetimeoffset()),
	[madeby] [varchar](50) NULL,
 CONSTRAINT [PK_configurationchange] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[customfield](
	[name] [varchar](50) NOT NULL,
	[value] [varchar](500) NOT NULL,
	[display] [bit] NOT NULL CONSTRAINT [DF_customfield_display]  DEFAULT ((1)),
	[displayindex] [int] NOT NULL,
	[uieditable] [bit] NOT NULL,
	[handhelddisplay] [bit] NOT NULL,
	[handheldvalue] [varchar](50) NOT NULL,
	[handhelddisplayindex] [int] NOT NULL,
	[datatype] [varchar](50) NOT NULL,
 CONSTRAINT [PK_customfield] PRIMARY KEY CLUSTERED 
(
	[name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[customfieldvalue](
	[customfieldname] [varchar](50) NOT NULL,
	[value] [varchar](50) NOT NULL,
	[displayindex] [int] NOT NULL
) ON [PRIMARY];

CREATE TABLE [dbo].[event](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[eventtime] [datetimeoffset](7) NOT NULL,
	[rfidtag] [varchar](50) NULL,
	[readername] [varchar](50) NULL,
	[readerlocation] [varchar](50) NULL,
	[assetname] [varchar](50) NULL,
	[assetdescription] [varchar](500) NULL,
	[eventtype] [varchar](50) NULL,
	[thresholdtype] [varchar](50) NULL,
	[eventdetails] [varchar](50) NULL,
	[filterannotation] [varchar](100) NULL,
	[antennanumber] [int] NULL,
	[rssi] [varchar](50) NULL,
	[locationname] [varchar](50) NULL,
	[vtagid] [varchar](50) NULL,
 CONSTRAINT [PK_event] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[filedata](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[data] [varchar](max) NOT NULL,
 CONSTRAINT [PK_filedata] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [dbo].[fixedvtag](
	[name] [varchar](100) NULL,
	[vtagid] [varchar](50) NOT NULL,
	[vtagx] [decimal](18, 0) NULL,
	[vtagy] [decimal](18, 0) NULL,
	[vtagz] [int] NULL,
	[vtagpositiontype] [varchar](50) NULL,
	[vtaglastseen] [datetimeoffset](7) NULL,
	[batterylevel] [decimal](18, 0) NULL,
	[readerid] [int] NULL,
	[locationid] [int] NULL,
	[id] [int] IDENTITY(1,1) NOT NULL,
	[lastmodifiedby] [varchar](50) NULL,
 CONSTRAINT [PK_fixedvtag_1] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[location](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NOT NULL,
	[site] [varchar](100) NULL,
	[building] [varchar](100) NULL,
	[floor] [varchar](50) NULL,
	[room] [varchar](100) NULL,
	[description] [varchar](500) NULL,
	[rfidtag] [varchar](50) NULL,
	[lastmodifiedby] [varchar](50) NULL,
 CONSTRAINT [PK_location] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[locationhistory](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[timeseen] [datetimeoffset](7) NOT NULL,
	[assetid] [int] NOT NULL,
	[locationid] [int] NOT NULL,
 CONSTRAINT [PK_locationhistory] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[maintenancehistory](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[whenperformed] [datetimeoffset](7) NOT NULL,
	[actionperformed] [varchar](500) NULL,
	[notes] [varchar](max) NULL,
	[performedby] [varchar](50) NULL,
	[assetid] [int] NOT NULL,
 CONSTRAINT [PK_maintenancehistory] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [dbo].[maparea](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[floorlevel] [int] NOT NULL,
	[name] [varchar](50) NOT NULL,
	[pixelspermeter] [decimal](18, 0) NOT NULL,
	[mapsiteid] [int] NOT NULL,
	[filedataid] [int] NULL,
	[imagewidth] [decimal](18, 0) NULL,
	[imageheight] [decimal](18, 0) NULL,
 CONSTRAINT [PK_maparea] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[mapsite](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NOT NULL,
	[originx] [decimal](18, 0) NOT NULL CONSTRAINT [DF_mapsite_originx]  DEFAULT ((0)),
	[originy] [decimal](18, 0) NOT NULL CONSTRAINT [DF_mapsite_originy]  DEFAULT ((0)),
 CONSTRAINT [PK_mapsite] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[plugin](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NOT NULL,
	[description] [varchar](500) NULL,
	[filedataid] [int] NOT NULL,
	[lastmodifiedby] [varchar](50) NULL
 CONSTRAINT [PK_plugin] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[printjob](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[recordid] [int] NOT NULL,
	[tablename] [varchar](50) NOT NULL,
	[templateid] [int] NOT NULL,
	[generatedrfid] [varchar](50) NULL,
	[completed] [bit] NOT NULL CONSTRAINT [DF_printjob_completed]  DEFAULT ((0)),
	[created] [datetimeoffset](7) NOT NULL CONSTRAINT [DF_printjob_created]  DEFAULT (sysdatetimeoffset()),
 CONSTRAINT [PK_printjob] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[queuedcommand](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[vtagid] [varchar](50) NULL,
	[commandtype] [varchar](50) NULL,
	[commandtext] [varchar](100) NULL,
	[status] [varchar](50) NULL,
	[lastattempt] [datetimeoffset](7) NULL,
	[created] [datetimeoffset](7) NOT NULL CONSTRAINT [DF_queuedcommand_created]  DEFAULT (sysdatetimeoffset()),
	[reason] [varchar](100) NULL,	
	[retrycount] [int] NOT NULL CONSTRAINT [DF_queuedcommand_retrycount]  DEFAULT ((0)),
	[readerid] [int] NULL,
 CONSTRAINT [PK_queuedcommand] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[reader](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NOT NULL,
	[readermodel] [varchar](50) NOT NULL,
	[radsmodeenabled] [bit] NOT NULL CONSTRAINT [DF_reader_radsmodeenabled]  DEFAULT ('false'),
	[port] [varchar](100) NULL,
	[portstring] [varchar](100) NULL,
	[devicesettings] [varchar](100) NULL,
	[connectionstatus] [varchar](50) NULL,
	[usewithservice] [varchar](50) NULL,
	[locationid] [int] NULL,
	[assetmovedalertingactionid] [int] NULL,
	[lowbatteryalertingactionid] [int] NULL,
	[sensorthresholdalertingactionid] [int] NULL,
	[innerdirectionalertingactionid] [int] NULL,
	[outerdirectionalertingactionid] [int] NULL,
	[mapsiteid] [int] NULL,
	[readerdisconnectedalertingactionid] [int] NULL,
	[lastmodifiedby] [varchar](50) NULL,
 CONSTRAINT [PK_reader] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[sensorreading](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[vtagid] [varchar](50) NULL,
	[name] [varchar](50) NULL,
	[created] [datetimeoffset](7) NOT NULL,
	[sourcedistancehops] [varchar](50) NULL,
	[ttl] [int] NULL,
	[minimumtemperaturedegc] [decimal](18, 0) NULL,
	[maximumtemperaturedegc] [decimal](18, 0) NULL,
	[minimumhumiditypercent] [decimal](18, 0) NULL,
	[maximumhumiditypercent] [decimal](18, 0) NULL,
	[batteryvolts] [decimal](18, 0) NULL,
	[x] [decimal](18, 0) NULL,
	[y] [decimal](18, 0) NULL,
	[z] [int] NULL,
	[locationconfidence] [varchar](50) NULL,
	[maximumaccelerationg] [decimal](18, 0) NULL,
	[maximumlightlevellux] [decimal](18, 0) NULL,
 CONSTRAINT [PK_sensorreading] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[sensorstat](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[vtagid] [varchar](50) NULL,
	[created] [datetimeoffset](7) NULL,
	[sourcedistancehops] [varchar](50) NULL,
	[ttl] [int] NULL,
	[numneighbors] [int] NULL,
	[numactiveneighbors] [int] NULL,
	[totalerrors] [int] NULL,
	[lasterror] [int] NULL,
	[bestneighbor] [varchar](50) NULL,
	[bestneighborrssidbm] [int] NULL,
	[minqueue] [int] NULL,
	[maxqueue] [int] NULL,
	[avgqueue] [int] NULL,
	[processedpackets] [int] NULL,
	[alarmcount] [int] NULL,
	[firmwareversion] [int] NULL,
	[movementtriggers] [int] NULL,
	[suspecttriggers] [varchar](50) NULL,
	[dayssincereset] [decimal](18, 0) NULL,
	[leafdroppedpackets] [int] NULL,
 CONSTRAINT [PK_sensorstat] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[serverstatus](
	[name] [varchar](50) NOT NULL,
	[lastseen] [datetimeoffset](7) NOT NULL CONSTRAINT [DF_serverstatus_lastseen]  DEFAULT (sysdatetimeoffset()),
 CONSTRAINT [PK_serverstatus] PRIMARY KEY CLUSTERED 
(
	[name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE TABLE [dbo].[session](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[ticketid] [varchar](5000) NULL,
	[name] [varchar](50) NULL,
	[lastmodified] [datetimeoffset](7) NULL CONSTRAINT [DF_session_lastmodified]  DEFAULT (sysdatetimeoffset()),
 CONSTRAINT [PK_session] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[sysuser](
	[username] [nvarchar](50) NOT NULL,
	[password] [nvarchar](max) NULL,
	[firstname] [nvarchar](50) NULL,
	[lastname] [nvarchar](50) NULL,
	[email] [nvarchar](50) NULL,
	[phone] [nvarchar](50) NULL,
	[cardid] [nvarchar](50) NULL,
	[hideadminpopups] [bit] NOT NULL CONSTRAINT [DF_sysuser_hideadminpopups]  DEFAULT ((0)),
	[viewonly] [bit] NOT NULL CONSTRAINT [DF_sysuser_viewonly]  DEFAULT ((0)),
	[rfidtag] [nvarchar](50) NULL,
	[id] [int] IDENTITY(1,1) NOT NULL,
 CONSTRAINT [PK_sysuser] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];

CREATE TABLE [dbo].[template](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NULL,
	[templatetype] [varchar](50) NULL,
	[filename] [varchar](50) NULL,
	[usewithservice] [varchar](50) NULL,
 CONSTRAINT [PK_template] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY];

CREATE VIEW [dbo].[v_sensorreading] AS
select sr.id,sr.vtagid,sr.name,sr.created,sr.sourcedistancehops,sr.ttl,sr.minimumhumiditypercent,sr.maximumhumiditypercent,sr.batteryvolts,sr.z,sr.locationconfidence,sr.maximumaccelerationg,sr.maximumlightlevellux,
CASE WHEN appSetting.UseMeters=1 THEN x ELSE ROUND(convert(decimal(18,2), x * 3.28), 2) END AS x,
CASE WHEN appSetting.UseMeters=1 THEN y ELSE ROUND(y * 3.28, 2) END AS y,
CASE WHEN appSetting.TemperatureFormat='Fahrenheit' THEN ROUND(convert(decimal(18,2),minimumtemperaturedegc * 9 / 5 + 32), 2) ELSE minimumtemperaturedegc END AS minimumtemperaturedegc,
CASE WHEN appSetting.TemperatureFormat='Fahrenheit' THEN ROUND(convert(decimal(18,2),maximumtemperaturedegc * 9 / 5 + 32), 2) ELSE maximumtemperaturedegc END AS maximumtemperaturedegc
from sensorreading sr CROSS JOIN applicationsetting AS appSetting

CREATE VIEW [dbo].[vtag] AS
select vtagid,vtagx,vtagy,vtagz,vtagpositiontype,vtaglastseen,batterylevel,readerid from asset
union
select vtagid,vtagx,vtagy,vtagz,vtagpositiontype,vtaglastseen,batterylevel,readerid from fixedvtag;

CREATE VIEW [dbo].[v_batterylevel] AS 
 SELECT a.name AS assetname,
    vt.vtagid,
    vt.vtagx,
    vt.vtagy,
    vt.vtagz,
    vt.vtagpositiontype,
    vt.vtaglastseen,
    vt.batterylevel
   FROM vtag vt
     LEFT JOIN asset a ON a.vtagid = vt.vtagid;

CREATE VIEW [dbo].[v_vtag] AS 
 SELECT vtag.vtagid,
    vtag.vtagx,
    vtag.vtagy,
    vtag.vtagz,
    vtag.vtagpositiontype,
    vtag.vtaglastseen,
    vtag.batterylevel,
    vtag.readerid
   FROM vtag
  WHERE NOT vtag.vtagid IS NULL;

CREATE VIEW [dbo].[v_asset] AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid;

CREATE VIEW [dbo].[v_assetvtag] AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing') AS locationname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
  WHERE NOT a.vtagid IS NULL;

CREATE VIEW [dbo].[v_checkouthistory] AS 
 SELECT a.name AS assetname,
    ch.id,
    ch.checkinstatus,
    ch.individual,
    ch.transactiontime,
    ch.assetid
   FROM asset a,
    checkouthistory ch
  WHERE a.id = ch.assetid;

CREATE VIEW [dbo].[v_fixedvtag] AS 
 SELECT COALESCE(l.name, 'Missing') AS locationname,
    r.name AS readername,
    vt.vtagid,
    vt.vtagx,
    vt.vtagy,
    vt.vtagz,
    vt.vtagpositiontype,
    vt.vtaglastseen,
    vt.batterylevel,
    vt.readerid,
    vt.locationid,
    vt.id
   FROM fixedvtag vt
     LEFT JOIN location l ON l.id = vt.locationid
     LEFT JOIN reader r ON r.id = vt.readerid;

CREATE VIEW [dbo].[v_locationhistory] AS 
 SELECT lh.id,
    lh.timeseen,
    lh.assetid,
    lh.locationid,
    a.name AS assetname,
    a.description AS assetdescription,
    COALESCE(l.name, 'Missing') AS locationname
   FROM locationhistory lh
     LEFT JOIN location l ON l.id = lh.locationid
     LEFT JOIN asset a ON a.id = lh.assetid;

CREATE VIEW [dbo].[v_maintenancehistory] AS 
 SELECT mh.id,
    mh.whenperformed,
    mh.actionperformed,
    mh.notes,
    mh.performedby,
    mh.assetid,
    a.name AS assetname,
    a.description AS assetdescription
   FROM asset a,
    maintenancehistory mh
  WHERE a.id = mh.assetid;

CREATE VIEW [dbo].[v_site] AS 
 SELECT DISTINCT location.site
   FROM location
  WHERE NOT location.site is NULL;

ALTER TABLE [dbo].[alarm] ADD  CONSTRAINT [DF_alarm_alarmtime]  DEFAULT (sysdatetimeoffset()) FOR [alarmtime];

ALTER TABLE [dbo].[changelog] ADD  CONSTRAINT [DF_changelog_changedate]  DEFAULT (sysdatetimeoffset()) FOR [changedate];

ALTER TABLE [dbo].[checkouthistory] ADD  CONSTRAINT [DF_checkouthistory_transactiontime]  DEFAULT (sysdatetimeoffset()) FOR [transactiontime];

ALTER TABLE [dbo].[event] ADD  CONSTRAINT [DF_event_eventtime]  DEFAULT (sysdatetimeoffset()) FOR [eventtime];

ALTER TABLE [dbo].[locationhistory] ADD  CONSTRAINT [DF_locationhistory_timeseen]  DEFAULT (sysdatetimeoffset()) FOR [timeseen];

ALTER TABLE [dbo].[maintenancehistory] ADD  CONSTRAINT [DF_maintenancehistory_whenperformed]  DEFAULT (sysdatetimeoffset()) FOR [whenperformed];

ALTER TABLE [dbo].[sensorreading] ADD  CONSTRAINT [DF_sensorreading_created]  DEFAULT (sysdatetimeoffset()) FOR [created];

ALTER TABLE [dbo].[sensorstat] ADD  CONSTRAINT [DF_sensorstat_created]  DEFAULT (sysdatetimeoffset()) FOR [created];

ALTER TABLE [dbo].[antenna]  WITH CHECK ADD  CONSTRAINT [FK_antenna_alertingaction] FOREIGN KEY([alertingactionid])
REFERENCES [dbo].[alertingaction] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[antenna] CHECK CONSTRAINT [FK_antenna_alertingaction];

ALTER TABLE [dbo].[antenna]  WITH CHECK ADD  CONSTRAINT [FK_antenna_location] FOREIGN KEY([locationid])
REFERENCES [dbo].[location] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[antenna] CHECK CONSTRAINT [FK_antenna_location];

ALTER TABLE [dbo].[antenna]  WITH CHECK ADD  CONSTRAINT [FK_antenna_reader] FOREIGN KEY([readerid])
REFERENCES [dbo].[reader] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[antenna] CHECK CONSTRAINT [FK_antenna_reader];

ALTER TABLE [dbo].[asset]  WITH CHECK ADD  CONSTRAINT [FK_asset_alertingaction] FOREIGN KEY([alertingactionid])
REFERENCES [dbo].[alertingaction] ([id])
ON DELETE SET NULL;

ALTER TABLE [dbo].[asset] CHECK CONSTRAINT [FK_asset_alertingaction];

ALTER TABLE [dbo].[asset]  WITH CHECK ADD  CONSTRAINT [fk_asset_asset] FOREIGN KEY([assetparentid])
REFERENCES [dbo].[asset] ([id]);

ALTER TABLE [dbo].[asset] CHECK CONSTRAINT [fk_asset_asset];

ALTER TABLE [dbo].[asset]  WITH CHECK ADD  CONSTRAINT [FK_asset_location] FOREIGN KEY([locationid])
REFERENCES [dbo].[location] ([id])
ON DELETE SET NULL;

ALTER TABLE [dbo].[asset] CHECK CONSTRAINT [FK_asset_location];

ALTER TABLE [dbo].[asset]  WITH CHECK ADD  CONSTRAINT [FK_asset_reader] FOREIGN KEY([readerid])
REFERENCES [dbo].[reader] ([id])
ON DELETE SET NULL;

ALTER TABLE [dbo].[asset] CHECK CONSTRAINT [FK_asset_reader];

ALTER TABLE [dbo].[checkouthistory]  WITH CHECK ADD  CONSTRAINT [FK_checkouthistory_asset] FOREIGN KEY([assetid])
REFERENCES [dbo].[asset] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[checkouthistory] CHECK CONSTRAINT [FK_checkouthistory_asset];

ALTER TABLE [dbo].[customfieldvalue]  WITH CHECK ADD  CONSTRAINT [FK_customfieldvalue_customfield] FOREIGN KEY([customfieldname])
REFERENCES [dbo].[customfield] ([name])
ON DELETE CASCADE;

ALTER TABLE [dbo].[customfieldvalue] CHECK CONSTRAINT [FK_customfieldvalue_customfield];

ALTER TABLE [dbo].[fixedvtag]  WITH CHECK ADD  CONSTRAINT [FK_fixedvtag_location] FOREIGN KEY([locationid])
REFERENCES [dbo].[location] ([id])
ON DELETE SET NULL;

ALTER TABLE [dbo].[fixedvtag] CHECK CONSTRAINT [FK_fixedvtag_location];

ALTER TABLE [dbo].[fixedvtag]  WITH CHECK ADD  CONSTRAINT [FK_fixedvtag_reader] FOREIGN KEY([readerid])
REFERENCES [dbo].[reader] ([id])
ON DELETE SET NULL;

ALTER TABLE [dbo].[fixedvtag] CHECK CONSTRAINT [FK_fixedvtag_reader];

ALTER TABLE [dbo].[locationhistory]  WITH CHECK ADD  CONSTRAINT [FK_locationhistory_asset] FOREIGN KEY([assetid])
REFERENCES [dbo].[asset] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[locationhistory] CHECK CONSTRAINT [FK_locationhistory_asset];

ALTER TABLE [dbo].[locationhistory]  WITH CHECK ADD  CONSTRAINT [FK_locationhistory_location] FOREIGN KEY([locationid])
REFERENCES [dbo].[location] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[locationhistory] CHECK CONSTRAINT [FK_locationhistory_location];

ALTER TABLE [dbo].[maintenancehistory]  WITH CHECK ADD  CONSTRAINT [FK_maintenancehistory_asset] FOREIGN KEY([assetid])
REFERENCES [dbo].[asset] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[maintenancehistory] CHECK CONSTRAINT [FK_maintenancehistory_asset];

ALTER TABLE [dbo].[maparea]  WITH CHECK ADD  CONSTRAINT [FK_maparea_filedata] FOREIGN KEY([filedataid])
REFERENCES [dbo].[filedata] ([id])
ON DELETE SET NULL;

ALTER TABLE [dbo].[maparea] CHECK CONSTRAINT [FK_maparea_filedata];

ALTER TABLE [dbo].[maparea]  WITH CHECK ADD  CONSTRAINT [FK_maparea_mapsite] FOREIGN KEY([mapsiteid])
REFERENCES [dbo].[mapsite] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[maparea] CHECK CONSTRAINT [FK_maparea_mapsite];

ALTER TABLE [dbo].[plugin]  WITH CHECK ADD  CONSTRAINT [FK_plugin_filedata] FOREIGN KEY([filedataid])
REFERENCES [dbo].[filedata] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[plugin] CHECK CONSTRAINT [FK_plugin_filedata];

ALTER TABLE [dbo].[printjob]  WITH CHECK ADD  CONSTRAINT [FK_printjob_template] FOREIGN KEY([templateid])
REFERENCES [dbo].[template] ([id])
ON DELETE CASCADE;

ALTER TABLE [dbo].[printjob] CHECK CONSTRAINT [FK_printjob_template];

ALTER TABLE [dbo].[queuedcommand]  WITH CHECK ADD  CONSTRAINT [FK_queuedcommand_reader] FOREIGN KEY([readerid])
REFERENCES [dbo].[reader] ([id])
ON DELETE SET NULL;

ALTER TABLE [dbo].[queuedcommand] CHECK CONSTRAINT [FK_queuedcommand_reader];

ALTER TABLE [dbo].[reader]  WITH CHECK ADD  CONSTRAINT [FK_reader_alertingaction_assetmoved] FOREIGN KEY([assetmovedalertingactionid])
REFERENCES [dbo].[alertingaction] ([id]);

ALTER TABLE [dbo].[reader] CHECK CONSTRAINT [FK_reader_alertingaction_assetmoved];

ALTER TABLE [dbo].[reader]  WITH CHECK ADD  CONSTRAINT [FK_reader_alertingaction_innerdirection] FOREIGN KEY([innerdirectionalertingactionid])
REFERENCES [dbo].[alertingaction] ([id]);

ALTER TABLE [dbo].[reader] CHECK CONSTRAINT [FK_reader_alertingaction_innerdirection];

ALTER TABLE [dbo].[reader]  WITH CHECK ADD  CONSTRAINT [FK_reader_alertingaction_lowbattery] FOREIGN KEY([lowbatteryalertingactionid])
REFERENCES [dbo].[alertingaction] ([id]);

ALTER TABLE [dbo].[reader] CHECK CONSTRAINT [FK_reader_alertingaction_lowbattery];

ALTER TABLE [dbo].[reader]  WITH CHECK ADD  CONSTRAINT [FK_reader_alertingaction_outerdirection] FOREIGN KEY([outerdirectionalertingactionid])
REFERENCES [dbo].[alertingaction] ([id]);

ALTER TABLE [dbo].[reader] CHECK CONSTRAINT [FK_reader_alertingaction_outerdirection];

ALTER TABLE [dbo].[reader]  WITH CHECK ADD  CONSTRAINT [FK_reader_alertingaction_readerdisconnected] FOREIGN KEY([readerdisconnectedalertingactionid])
REFERENCES [dbo].[alertingaction] ([id]);

ALTER TABLE [dbo].[reader] CHECK CONSTRAINT [FK_reader_alertingaction_readerdisconnected];

ALTER TABLE [dbo].[reader]  WITH CHECK ADD  CONSTRAINT [FK_reader_alertingaction_sensorthreshold] FOREIGN KEY([sensorthresholdalertingactionid])
REFERENCES [dbo].[alertingaction] ([id]);

ALTER TABLE [dbo].[reader] CHECK CONSTRAINT [FK_reader_alertingaction_sensorthreshold];

ALTER TABLE [dbo].[reader]  WITH CHECK ADD  CONSTRAINT [FK_reader_location] FOREIGN KEY([locationid])
REFERENCES [dbo].[location] ([id])
ON DELETE SET NULL;

ALTER TABLE [dbo].[reader] CHECK CONSTRAINT [FK_reader_location];

ALTER TABLE [dbo].[reader]  WITH CHECK ADD  CONSTRAINT [FK_reader_mapsiteid] FOREIGN KEY([mapsiteid])
REFERENCES [dbo].[mapsite] ([id]);

ALTER TABLE [dbo].[reader] CHECK CONSTRAINT [FK_reader_mapsiteid];

CREATE TRIGGER trg_alarmack_after_delete
ON dbo.alarmack
AFTER DELETE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'alarmack', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

CREATE TRIGGER trg_alarmack_after_update
ON dbo.alarmack
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'alarmack', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

CREATE TRIGGER trg_alertingaction_after_insert
ON dbo.alertingaction
AFTER INSERT 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'alertingaction', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;


CREATE TRIGGER trg_alertingaction_after_update
ON dbo.alertingaction
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'alertingaction', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

CREATE TRIGGER trg_alertingaction_instead_delete
ON alertingaction
INSTEAD OF DELETE 
AS
BEGIN
	UPDATE asset SET asset.lastmodifiedby='db_default', asset.alertingactionid=null from asset INNER JOIN Deleted d on asset.alertingactionid=d.id;    		
	UPDATE r SET r.lastmodifiedby='db_default' from reader r INNER JOIN Deleted d on 
		r.assetmovedalertingactionid=d.id OR r.lowbatteryalertingactionid=d.id OR r.sensorthresholdalertingactionid=d.id OR r.innerdirectionalertingactionid=d.id
		OR r.outerdirectionalertingactionid=d.id OR r.readerdisconnectedalertingactionid=d.id;
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby) SELECT 'alertingaction', 'Delete', d.id, 'db_trigger' FROM Deleted d;
	DELETE a from antenna as a INNER JOIN deleted as d on a.alertingactionid=d.id;	
	DELETE aa from alertingaction as aa INNER JOIN deleted as d on aa.id=d.id;
END

CREATE TRIGGER trg_applicationsetting_after_update
ON dbo.applicationsetting
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'applicationsetting', 'Edit', d.id, 'db_trigger'
        FROM inserted d;

CREATE TRIGGER trg_antenna_after_update
ON dbo.antenna
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'antenna', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;


CREATE TRIGGER trg_antenna_after_delete
ON dbo.antenna
AFTER DELETE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'antenna', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

CREATE TRIGGER trg_antenna_after_insert
ON dbo.antenna
AFTER INSERT 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'antenna', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

CREATE TRIGGER trg_plugin_after_update
ON dbo.plugin
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'plugin', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

CREATE TRIGGER trg_plugin_after_delete
ON dbo.plugin
AFTER DELETE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'plugin', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

CREATE TRIGGER trg_plugin_after_insert
ON dbo.plugin
AFTER INSERT 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'plugin', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

CREATE TRIGGER trg_asset_after_insert
ON dbo.asset
AFTER INSERT 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'asset', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

CREATE TRIGGER trg_asset_after_update
ON dbo.asset
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'asset', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

CREATE TRIGGER trg_asset_after_delete
ON dbo.asset
AFTER DELETE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'asset', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

CREATE TRIGGER trg_fixedvtag_after_update
ON dbo.fixedvtag
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'fixedvtag', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

CREATE TRIGGER trg_fixedvtag_after_insert
ON dbo.fixedvtag
AFTER INSERT 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'fixedvtag', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

CREATE TRIGGER trg_fixedvtag_after_delete
ON dbo.fixedvtag
AFTER DELETE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'fixedvtag', 'Delete', d.id, 'db_trigger'
        FROM Deleted d;

CREATE TRIGGER trg_location_after_insert
ON dbo.location
AFTER INSERT 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'location', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

CREATE TRIGGER trg_location_after_update
ON dbo.location
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'location', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

CREATE TRIGGER trg_location_instead_delete
ON location
INSTEAD OF DELETE 
AS
BEGIN
	UPDATE asset SET asset.lastmodifiedby='db_default', asset.locationid=null from asset INNER JOIN Deleted d on asset.locationid=d.id;    
	UPDATE t SET t.lastmodifiedby='db_default', t.locationid=null from fixedvtag t INNER JOIN Deleted d on t.locationid=d.id;    
	UPDATE t SET t.lastmodifiedby='db_default', t.locationid=null from reader t INNER JOIN Deleted d on t.locationid=d.id;    
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby) SELECT 'location', 'Delete', d.id, 'db_trigger' FROM Deleted d;
	DELETE a from antenna as a INNER JOIN deleted as d on a.locationid=d.id;
	DELETE lh from locationhistory as lh INNER JOIN deleted as d on lh.locationid=d.id;	
	DELETE l from location as l INNER JOIN deleted as d on l.id=d.id;
END

CREATE TRIGGER trg_reader_after_insert
ON dbo.reader
AFTER INSERT 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'reader', 'Add', d.id, d.lastmodifiedby
        FROM Inserted d;

CREATE TRIGGER trg_reader_after_update
ON dbo.reader
AFTER UPDATE 
AS
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby)
        SELECT 'reader', 'Edit', d.id, d.lastmodifiedby
        FROM inserted d;

CREATE TRIGGER trg_reader_instead_delete
ON reader
INSTEAD OF DELETE 
AS
BEGIN
	UPDATE asset SET asset.lastmodifiedby='db_default', asset.readerid=null from asset INNER JOIN Deleted d on asset.readerid=d.id;    		
	UPDATE fixedvtag SET fixedvtag.lastmodifiedby='db_default', fixedvtag.readerid=null from fixedvtag INNER JOIN Deleted d on fixedvtag.readerid=d.id;    		
    INSERT INTO configurationchange(modifiedtable,changeevent,recordid,madeby) SELECT 'reader', 'Delete', d.id, 'db_trigger' FROM Deleted d;
	DELETE qq from queuedcommand as qq INNER JOIN deleted as d on qq.readerid=d.id;	
	DELETE a from antenna as a INNER JOIN deleted as d on a.readerid=d.id;	
	DELETE r from reader as r INNER JOIN deleted as d on r.id=d.id;
END
