﻿CREATE TABLE public.employee
(
  id serial NOT NULL,
  companyid integer NOT NULL,
  firstname text,
  lastname text,
  email text,
  phone text,
  rfidtag text,  
  lastseen timestamp with time zone NULL,
  locationid integer,
  CONSTRAINT pk_employee_id PRIMARY KEY (id),
  CONSTRAINT fk_employee_company FOREIGN KEY (companyid)
      REFERENCES public.company (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT fk_employee_location FOREIGN KEY (locationid)
      REFERENCES public.location (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE SET NULL
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.employee
  OWNER TO postgres;

CREATE UNIQUE INDEX index_employee_id_companyid ON employee(id,companyid);

CREATE OR REPLACE VIEW public.v_employee AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname,
	COALESCE(l.site, ''::text) AS locationsite,
    COALESCE(l.building, ''::text) AS locationbuilding,
    COALESCE(l.floor, ''::text) AS locationfloor,
    COALESCE(l.room, ''::text) AS locationroom,
    COALESCE(l.description, ''::text) AS locationdescription
   FROM employee a
     LEFT JOIN location l ON l.id = a.locationid;     

CREATE TABLE public.employeelocationhistory
(
  id serial NOT NULL,
  companyid integer NULL,
  timeseen timestamp with time zone NOT NULL DEFAULT now(),
  timeleft timestamp with time zone NULL,
  employeeid integer NOT NULL,
  locationid integer,
  CONSTRAINT pk_employeelocationhistory_id PRIMARY KEY (id),
  CONSTRAINT fk_employeelocationhistory_asset FOREIGN KEY (employeeid)
      REFERENCES public.employee (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT fk_employeelocationhistory_location FOREIGN KEY (locationid)
      REFERENCES public.location (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.employeelocationhistory
  OWNER TO postgres;

CREATE OR REPLACE VIEW public.v_employeelocationhistory AS 
 SELECT lh.id,
    lh.timeseen,
    lh.timeleft,
    lh.employeeid,
    lh.locationid,
    lh.companyid,
    e.firstname AS employeefirstname,
	e.lastname AS employeelastname,
	e.email AS employeeemail,    
    COALESCE(l.name, 'Missing') AS locationname
   FROM employeelocationhistory lh
     LEFT JOIN location l ON l.id = lh.locationid
     LEFT JOIN employee e ON e.id = lh.employeeid;

CREATE UNIQUE INDEX index_employeelocationhistory_id_companyid ON employeelocationhistory(id,companyid);

CREATE TABLE public.scanner
(
  id serial NOT NULL,
  companyname text NOT NULL,
  deviceid text,
  inactive boolean,
  description text,
  lastseen timestamp with time zone NULL DEFAULT now(),
  CONSTRAINT pk_scanner_id PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.employee
  OWNER TO postgres;

ALTER TABLE public.reader ADD mqttcontroltopic text NULL;

CREATE OR REPLACE VIEW public.v_reader AS 
 SELECT COALESCE(l.name, 'Missing'::text) AS locationname,
    r.*
   FROM reader r
     LEFT JOIN location l ON l.id = r.locationid
  ORDER BY r.name;

ALTER TABLE public.v_reader
  OWNER TO postgres;
