﻿CREATE TABLE public.printclient
(
  id serial NOT NULL,
  companyid integer NULL,
  name text,
  username text,
  password text,
  machinename text,  
  lastseen timestamp with time zone,
  CONSTRAINT pk_printclient_id PRIMARY KEY (id),
  CONSTRAINT fk_printclient_company FOREIGN KEY (companyid)
      REFERENCES public.company (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.printclient
  OWNER TO postgres;

CREATE UNIQUE INDEX index_printclient_name ON printclient(name);

CREATE TABLE public.printclientcompany
(
  id serial NOT NULL,
  printclientid integer NOT NULL,
  companyid integer NOT NULL,
  CONSTRAINT pk_printclientcompany_id PRIMARY KEY (id),
  CONSTRAINT fk_printclientcompany_printclient FOREIGN KEY (printclientid)
      REFERENCES public.printclient (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT fk_printclientcompany_company FOREIGN KEY (companyid)
      REFERENCES public.company (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.printclientcompany
  OWNER TO postgres;

ALTER TABLE public.template ADD column printclientid INTEGER;

ALTER TABLE public.template add constraint fk_template_printclient
   foreign key (printclientid)
   references printclient(id)
   on delete cascade;

ALTER TABLE public.serverstatus ADD column servertype text;

CREATE OR REPLACE VIEW public.v_template AS SELECT t.*,pc.name as printclientname FROM template t LEFT JOIN printclient pc ON pc.id=t.printclientid;

ALTER TABLE public.v_template
  OWNER TO postgres;

alter table public.serverstatus alter column companyid DROP NOT NULL;

alter table public.serverstatus drop constraint PK_serverstatus;

alter table public.serverstatus add column id serial NOT NULL;

alter table public.serverstatus add primary key (id);