﻿ALTER TABLE public.locationhistory ADD timeleft timestamp with time zone NULL;

drop view v_locationhistory;

CREATE OR REPLACE VIEW public.v_locationhistory AS 
 SELECT lh.*,
    a.name AS assetname,
    a.description AS assetdescription,
    COALESCE(l.name, 'Missing'::text) AS locationname
   FROM locationhistory lh
     LEFT JOIN location l ON l.id = lh.locationid
     LEFT JOIN asset a ON a.id = lh.assetid
  ORDER BY lh.assetid, lh.timeseen DESC;

ALTER TABLE public.applicationsetting ADD enableassetunseen boolean NULL;

ALTER TABLE public.applicationsetting ADD enableglobaleventmessages boolean NULL;

ALTER TABLE public.applicationsetting ADD enableglobalalarmmessages boolean NULL;

ALTER TABLE public.applicationsetting ADD enableglobalgatewaymessages boolean NULL;

ALTER TABLE public.applicationsetting ADD enableglobalsensorreadingmessages boolean NULL;

ALTER TABLE public.applicationsetting ADD enableglobaltagmovementmessages boolean NULL;

ALTER TABLE public.applicationsetting ADD enableglobaltagobservationmessages boolean NULL;

ALTER TABLE public.reader ADD column ipaddress TEXT NULL;

ALTER TABLE public.reader ADD column username TEXT NULL;

ALTER TABLE public.reader ADD column password TEXT NULL;

ALTER TABLE public.reader ADD column lastmodified timestamp with time zone NULL;

ALTER TABLE public.asset ADD column unseennotified boolean NULL;

update reader set ipaddress=(select split_part(ir.portstring,',',1) from reader ir where ir.id=reader.id), port=(select split_part(ir.portstring,',',2) from reader ir where ir.id=reader.id), username=(select split_part(ir.portstring,',',3) from reader ir where ir.id=reader.id), password=(select split_part(ir.portstring,',',4) from reader ir where ir.id=reader.id);

CREATE INDEX index_reader_physicalid_companyid ON reader(physicalid,companyid);

CREATE INDEX index_reader_usewithservice_companyid ON reader(usewithservice,companyid);

CREATE UNIQUE INDEX index_fixedvtag_vtagid_companyid ON fixedvtag(vtagid,companyid);

ALTER TABLE public.queuedcommand ADD column amsname TEXT NULL;

DROP VIEW public.v_reader;

alter table public.reader drop column portstring;

CREATE INDEX index_queuedcommand_status_companyid_amsname ON queuedcommand(status,companyid,amsname);

CREATE INDEX index_queuedcommand_readerid_companyid ON queuedcommand(companyid,readerid);

DROP TRIGGER alarmack_insert_delete_configuration_change on alarmack;

DROP TRIGGER alertingaction_insert_delete_configuration_change on alertingaction;

DROP TRIGGER applicationsetting_insert_delete_configuration_change on applicationsetting;

DROP TRIGGER plugin_insert_delete_configuration_change on plugin;

DROP TRIGGER asset_insert_delete_configuration_change on asset;

DROP TRIGGER fixedvtag_insert_delete_configuration_change on fixedvtag;

DROP TRIGGER location_insert_delete_configuration_change on location;

DROP TRIGGER reader_insert_delete_configuration_change on reader;

DROP TRIGGER IF EXISTS trg_locationhistory_after_insert on locationhistory;

DROP VIEW public.v_asset;

CREATE OR REPLACE VIEW public.v_asset AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname,
	COALESCE(l.site, 'Missing'::text) AS locationsite,
    COALESCE(l.building, 'Missing'::text) AS locationbuilding,
    COALESCE(l.floor, 'Missing'::text) AS locationfloor,
    COALESCE(l.room, 'Missing'::text) AS locationroom,
    COALESCE(l.description, 'Missing'::text) AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed AND fvt.companyid=a.companyid;

ALTER TABLE public.v_asset
  OWNER TO postgres;

CREATE OR REPLACE VIEW v_reader AS 
SELECT COALESCE(l.name, 'Missing') AS locationname,
    r.*
   FROM reader r
     LEFT JOIN location l ON l.id = r.locationid;

CREATE TABLE public.mqttclient
(
  id serial NOT NULL,
  companyid integer,
  username text,
  password text,
  accessgatewaymessages boolean,
  accesstagmovements boolean,
  accesstagobservations boolean,
  accessevents boolean,
  accessalarms boolean,
  accessvtagsensors boolean,
  CONSTRAINT pk_mqttclient_id PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);

ALTER TABLE public.mqttclient
  OWNER TO postgres;

CREATE UNIQUE INDEX index_mqttclient_id_companyid ON mqttclient(id,companyid);

drop table configurationchange;