﻿CREATE TABLE public.company
(
  id serial NOT NULL,
  name text,  
  CONSTRAINT pk_company_id PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);

ALTER TABLE public.company
  OWNER TO postgres;

INSERT INTO company (name) values ('Main Company');

ALTER TABLE public.asset ADD COLUMN companyid integer;

UPDATE ASSET SET companyid=(select id from company);

ALTER TABLE public.asset ALTER COLUMN companyid SET NOT NULL;

CREATE UNIQUE INDEX index_asset_id_companyid ON asset(id,companyid);

ALTER TABLE public.alarm ADD COLUMN companyid integer NULL;

UPDATE alarm SET companyid=(select id from company);

ALTER TABLE public.alarm ALTER COLUMN companyid SET NOT NULL;

CREATE UNIQUE INDEX index_alarm_id_companyid ON alarm(id,companyid);

ALTER TABLE public.alarmack ADD COLUMN companyid integer NULL;

UPDATE alarmack SET companyid=(select id from company);

ALTER TABLE public.alarmack ALTER COLUMN companyid SET NOT NULL;

CREATE UNIQUE INDEX index_alarmack_id_companyid ON alarmack(id,companyid);

ALTER TABLE public.alertingaction ADD COLUMN companyid integer NULL;
UPDATE alertingaction SET companyid=(select id from company);
ALTER TABLE public.alertingaction ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_alertingaction_id_companyid ON alertingaction(id,companyid);




ALTER TABLE public.antenna ADD COLUMN companyid integer NULL;
UPDATE antenna SET companyid=(select id from company);
ALTER TABLE public.antenna ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_antenna_id_companyid ON antenna(id,companyid);

ALTER TABLE public.checkouthistory ADD COLUMN companyid integer NULL;
UPDATE checkouthistory SET companyid=(select id from company);
ALTER TABLE public.checkouthistory ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_checkouthistory_id_companyid ON checkouthistory(id,companyid);

ALTER TABLE public.clientapp ADD COLUMN companyid integer NULL;
UPDATE clientapp SET companyid=(select id from company);
ALTER TABLE public.clientapp ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_clientapp_id_companyid ON clientapp(id,companyid);

TRUNCATE TABLE configurationchange;
ALTER TABLE public.configurationchange ADD COLUMN companyid integer NULL;

ALTER TABLE public.event ADD COLUMN companyid integer NULL;
UPDATE public.event SET companyid=(select id from company);
ALTER TABLE public.event ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_event_id_companyid ON event(id,companyid);

ALTER TABLE public.filedata ADD COLUMN companyid integer NULL;
UPDATE filedata SET companyid=(select id from company);
ALTER TABLE public.filedata ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_filedata_id_companyid ON filedata(id,companyid);

ALTER TABLE public.fixedvtag ADD COLUMN companyid integer NULL;
UPDATE fixedvtag SET companyid=(select id from company);
ALTER TABLE public.fixedvtag ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_fixedvtag_id_companyid ON fixedvtag(id,companyid);

ALTER TABLE public.gpslocationhistory ADD COLUMN companyid integer NULL;
UPDATE gpslocationhistory SET companyid=(select id from company);
ALTER TABLE public.gpslocationhistory ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_gpslocationhistory_id_companyid ON gpslocationhistory(id,companyid);

ALTER TABLE public.location ADD COLUMN companyid integer NULL;
UPDATE location SET companyid=(select id from company);
ALTER TABLE public.location ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_location_id_companyid ON location(id,companyid);

ALTER TABLE public.locationhistory ADD COLUMN companyid integer NULL;
UPDATE locationhistory SET companyid=(select id from company);
ALTER TABLE public.locationhistory ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_locationhistory_id_companyid ON locationhistory(id,companyid);

ALTER TABLE public.maintenancehistory ADD COLUMN companyid integer NULL;
UPDATE maintenancehistory SET companyid=(select id from company);
ALTER TABLE public.maintenancehistory ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_maintenancehistory_id_companyid ON maintenancehistory(id,companyid);

ALTER TABLE public.maparea ADD COLUMN companyid integer NULL;
UPDATE maparea SET companyid=(select id from company);
ALTER TABLE public.maparea ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_maparea_id_companyid ON maparea(id,companyid);

ALTER TABLE public.mapsite ADD COLUMN companyid integer NULL;
UPDATE mapsite SET companyid=(select id from company);
ALTER TABLE public.mapsite ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_mapsite_id_companyid ON mapsite(id,companyid);

ALTER TABLE public.plugin ADD COLUMN companyid integer NULL;
UPDATE plugin SET companyid=(select id from company);
ALTER TABLE public.plugin ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_plugin_id_companyid ON plugin(id,companyid);

ALTER TABLE public.printjob ADD COLUMN companyid integer NULL;
UPDATE printjob SET companyid=(select id from company);
ALTER TABLE public.printjob ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_printjob_id_companyid ON printjob(id,companyid);

ALTER TABLE public.queuedcommand ADD COLUMN companyid integer NULL;
UPDATE queuedcommand SET companyid=(select id from company);
ALTER TABLE public.queuedcommand ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_queuedcommand_id_companyid ON queuedcommand(id,companyid);

ALTER TABLE public.reader ADD COLUMN companyid integer NULL;
UPDATE reader SET companyid=(select id from company);
ALTER TABLE public.reader ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_reader_id_companyid ON reader(id,companyid);

ALTER TABLE public.sensorreading ADD COLUMN companyid integer NULL;
UPDATE sensorreading SET companyid=(select id from company);
ALTER TABLE public.sensorreading ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_sensorreading_id_companyid ON sensorreading(id,companyid);

ALTER TABLE public.sensorstat ADD COLUMN companyid integer NULL;
UPDATE sensorstat SET companyid=(select id from company);
ALTER TABLE public.sensorstat ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_sensorstat_id_companyid ON sensorstat(id,companyid);

ALTER TABLE public.serverstatus ADD COLUMN companyid integer NULL;
UPDATE serverstatus SET companyid=(select id from company);
ALTER TABLE public.serverstatus ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_serverstatus_id_companyid ON serverstatus(name,companyid);

ALTER TABLE public.sysuser ADD COLUMN companyid integer NULL;
UPDATE sysuser SET companyid=(select id from company);

ALTER TABLE public.template ADD COLUMN companyid integer NULL;
UPDATE template SET companyid=(select id from company);
ALTER TABLE public.template ALTER COLUMN companyid SET NOT NULL;
CREATE UNIQUE INDEX index_template_id_companyid ON template(id,companyid);
 
CREATE OR REPLACE FUNCTION process_insert_delete_configuration_change() RETURNS TRIGGER AS $config_audit$ 
   BEGIN 
       IF(TG_OP = 'DELETE') THEN 
           INSERT INTO configurationchange(modifiedtable, changeevent, recordid, companyid, madeby) SELECT TG_ARGV[0], 'Delete', OLD.id, OLD.companyid, 'db_trigger';
           RETURN OLD; 
       ELSIF(TG_OP = 'UPDATE') THEN 
           INSERT INTO configurationchange(modifiedtable, changeevent, recordid, companyid, madeby) SELECT TG_ARGV[0], 'Edit', NEW.id, OLD.companyid, NEW.lastmodifiedby; 
           RETURN NEW;  
       ELSIF(TG_OP = 'INSERT') THEN 
           INSERT INTO configurationchange(modifiedtable, changeevent, recordid, companyid, madeby) SELECT TG_ARGV[0], 'Add', NEW.id, NEW.companyid, NEW.lastmodifiedby;
           RETURN NEW; 
       END IF; 
       RETURN NULL; --result is ignored since this is an AFTER trigger 
   END;
$config_audit$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION process_company_delete() RETURNS TRIGGER AS $company_delete$
    BEGIN        
        IF (TG_OP = 'DELETE') THEN
            DELETE from alarm as tabl where tabl.companyid=OLD.id;	
            DELETE from alarmack as tabl where tabl.companyid=OLD.id;
            DELETE from alertingaction as tabl where tabl.companyid=OLD.id;
            DELETE from antenna as tabl where tabl.companyid=OLD.id;
            DELETE from asset as tabl where tabl.companyid=OLD.id;
            DELETE from checkouthistory as tabl where tabl.companyid=OLD.id;
            DELETE from clientapp as tabl where tabl.companyid=OLD.id;
            DELETE from configurationchange as tabl where tabl.companyid=OLD.id;
            DELETE from event as tabl where tabl.companyid=OLD.id;
            DELETE from filedata as tabl where tabl.companyid=OLD.id;
            DELETE from fixedvtag as tabl where tabl.companyid=OLD.id;
            DELETE from gpslocationhistory as tabl where tabl.companyid=OLD.id;
            DELETE from location as tabl where tabl.companyid=OLD.id;
            DELETE from locationhistory as tabl where tabl.companyid=OLD.id;
            DELETE from maintenancehistory as tabl where tabl.companyid=OLD.id;
            DELETE from maparea as tabl where tabl.companyid=OLD.id;
            DELETE from mapsite as tabl where tabl.companyid=OLD.id;
            DELETE from plugin as tabl where tabl.companyid=OLD.id;
            DELETE from printjob as tabl where tabl.companyid=OLD.id;
            DELETE from queuedcommand as tabl where tabl.companyid=OLD.id;
            DELETE from reader as tabl where tabl.companyid=OLD.id;
            DELETE from sensorreading as tabl where tabl.companyid=OLD.id;
            DELETE from sensorstat as tabl where tabl.companyid=OLD.id;
            DELETE from serverstatus as tabl where tabl.companyid=OLD.id;
            DELETE from sysuser as tabl where tabl.companyid=OLD.id;
            DELETE from template as tabl where tabl.companyid=OLD.id;                        
            RETURN OLD;               
        END IF;
        RETURN NULL; -- result is ignored since this is an AFTER trigger
    END;
$company_delete$ LANGUAGE plpgsql;

CREATE TRIGGER company_delete
BEFORE DELETE ON company
    FOR EACH ROW EXECUTE PROCEDURE process_company_delete();

CREATE OR REPLACE FUNCTION process_insert_delete_applicationsetting_change() RETURNS TRIGGER AS $config_audit$ 
   BEGIN 
       IF(TG_OP = 'DELETE') THEN 
           INSERT INTO configurationchange(modifiedtable, changeevent, recordid, madeby) SELECT TG_ARGV[0], 'Delete', OLD.id, 'db_trigger';
           RETURN OLD; 
       ELSIF(TG_OP = 'UPDATE') THEN 
           INSERT INTO configurationchange(modifiedtable, changeevent, recordid, madeby) SELECT TG_ARGV[0], 'Edit', NEW.id, NEW.lastmodifiedby; 
           RETURN NEW;  
       ELSIF(TG_OP = 'INSERT') THEN 
           INSERT INTO configurationchange(modifiedtable, changeevent, recordid, madeby) SELECT TG_ARGV[0], 'Add', NEW.id, NEW.lastmodifiedby;
           RETURN NEW; 
       END IF; 
       RETURN NULL; --result is ignored since this is an AFTER trigger 
   END;
$config_audit$ LANGUAGE plpgsql;

DROP TRIGGER applicationsetting_insert_delete_configuration_change ON applicationsetting;
CREATE TRIGGER applicationsetting_insert_delete_configuration_change
AFTER UPDATE OR DELETE ON applicationsetting
  FOR EACH ROW EXECUTE PROCEDURE public.process_insert_delete_applicationsetting_change('ApplicationSetting');

DROP VIEW public.v_asset;

CREATE OR REPLACE VIEW public.v_asset AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname,
	COALESCE(l.site, 'Missing'::text) AS locationsite,
    COALESCE(l.building, 'Missing'::text) AS locationbuilding,
    COALESCE(l.floor, 'Missing'::text) AS locationfloor,
    COALESCE(l.room, 'Missing'::text) AS locationroom,
    COALESCE(l.description, 'Missing'::text) AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed AND fvt.companyid=a.companyid;

ALTER TABLE public.v_asset
  OWNER TO postgres;

drop view public.v_assetvtag;

CREATE OR REPLACE VIEW public.v_assetvtag AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname,
	COALESCE(l.site, 'Missing'::text) AS locationsite,
    COALESCE(l.building, 'Missing'::text) AS locationbuilding,
    COALESCE(l.floor, 'Missing'::text) AS locationfloor,
    COALESCE(l.room, 'Missing'::text) AS locationroom,
    COALESCE(l.description, 'Missing'::text) AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed AND fvt.companyid=a.companyid
  WHERE (NOT a.vtagid IS NULL) OR (NOT a.vtaggpsdeviceid IS NULL)
  ORDER BY a.vtagid;

ALTER TABLE public.v_assetvtag
  OWNER TO postgres;

drop view v_batterylevel;

CREATE OR REPLACE VIEW public.v_batterylevel AS 
 SELECT a.name AS assetname,
    vt.*
   FROM vtag vt
     LEFT JOIN asset a ON a.vtagid = vt.vtagid
  ORDER BY vt.batterylevel;

ALTER TABLE public.v_batterylevel
  OWNER TO postgres;

drop view v_checkouthistory;

CREATE OR REPLACE VIEW public.v_checkouthistory AS 
 SELECT a.name AS assetname,
    ch.*
   FROM asset a,
    checkouthistory ch
  WHERE a.id = ch.assetid;

ALTER TABLE public.v_checkouthistory
  OWNER TO postgres;

drop view v_fixedvtag;

CREATE OR REPLACE VIEW public.v_fixedvtag AS 
 SELECT COALESCE(l.name, 'Missing'::text) AS locationname,
    r.name AS readername,
    vt.*
   FROM fixedvtag vt
     LEFT JOIN location l ON l.id = vt.locationid
     LEFT JOIN reader r ON r.id = vt.readerid
  ORDER BY vt.vtagid;

ALTER TABLE public.v_fixedvtag
  OWNER TO postgres;

drop view v_locationhistory;

CREATE OR REPLACE VIEW public.v_locationhistory AS 
 SELECT lh.*,
    a.name AS assetname,
    a.description AS assetdescription,
    COALESCE(l.name, 'Missing'::text) AS locationname
   FROM locationhistory lh
     LEFT JOIN location l ON l.id = lh.locationid
     LEFT JOIN asset a ON a.id = lh.assetid
  ORDER BY lh.assetid, lh.timeseen DESC;

ALTER TABLE public.v_locationhistory
  OWNER TO postgres;

drop view v_maintenancehistory;

CREATE OR REPLACE VIEW public.v_maintenancehistory AS 
 SELECT mh.*,
    a.name AS assetname,
    a.description AS assetdescription
   FROM asset a,
    maintenancehistory mh
  WHERE a.id = mh.assetid;

ALTER TABLE public.v_maintenancehistory
  OWNER TO postgres;

drop view v_vtag;

CREATE OR REPLACE VIEW public.v_vtag AS 
 SELECT vtag.*
   FROM vtag
  WHERE NOT vtag.vtagid IS NULL
  ORDER BY vtag.vtagid;

ALTER TABLE public.v_vtag
  OWNER TO postgres;

drop view v_gpslocationhistory;

CREATE OR REPLACE VIEW public.v_gpslocationhistory AS 
 SELECT glh.*,
    a.name AS assetname,
    a.description AS assetdescription
   FROM gpslocationhistory glh
     LEFT JOIN asset a ON a.id = glh.assetid
  ORDER BY glh.assetid, glh.timeseen DESC;

ALTER TABLE public.v_gpslocationhistory
  OWNER TO postgres;

drop view if exists public.v_sysuser;

CREATE OR REPLACE VIEW public.v_sysuser AS 
 SELECT s.*,
    COALESCE(c.name, '') AS companyname
   FROM sysuser s
     LEFT JOIN company c ON c.id = s.companyid

drop view public.v_sensorreading;

CREATE OR REPLACE VIEW public.v_sensorreading AS 
select appSetting.TemperatureFormat, sr.id,sr.vtagid,sr.name,sr.created,sr.sourcedistancehops,sr.ttl,sr.minimumhumiditypercent,sr.maximumhumiditypercent,sr.batteryvolts,sr.z,sr.locationconfidence,sr.maximumaccelerationg,sr.maximumlightlevellux,sr.latitude,sr.longitude,sr.altitude,sr.numberofsatellites,sr.lastgpsfix,sr.vtagtype,sr.gpsaccuracy,sr.parentvtag,sr.companyid,
CASE WHEN UseMeters=true THEN x ELSE ROUND(x * 3.28, 2) END AS x,
CASE WHEN UseMeters=true THEN y ELSE ROUND(y * 3.28, 2) END AS y,
CASE WHEN TemperatureFormat='Fahrenheit' THEN ROUND(minimumtemperaturedegc * 9 / 5 + 32, 2) ELSE minimumtemperaturedegc END AS minimumtemperaturedegc,
CASE WHEN TemperatureFormat='Fahrenheit' THEN ROUND(maximumtemperaturedegc * 9 / 5 + 32, 2) ELSE maximumtemperaturedegc END AS maximumtemperaturedegc
from sensorreading sr CROSS JOIN applicationsetting AS appSetting;

ALTER TABLE public.v_sensorreading
  OWNER TO postgres;
