﻿CREATE TABLE public.gpslocationhistory
(
  id serial NOT NULL,
  timeseen timestamp with time zone NOT NULL DEFAULT now(),
  assetid integer NOT NULL,
  movement boolean,
  latitude numeric NOT NULL,
  longitude numeric NOT NULL,
  CONSTRAINT pk_gpslocationhistory_id PRIMARY KEY (id),
  CONSTRAINT fk_gpslocationhistory_asset FOREIGN KEY (assetid)
      REFERENCES public.asset (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.gpslocationhistory
  OWNER TO postgres;

CREATE TABLE public.clientapp
(
	id serial NOT NULL,
	clientid text NOT NULL,
	granttype text NOT NULL,
	secret text NULL,
	allowRefreshTokens boolean,
	CONSTRAINT pk_clientapp_id PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.clientapp
  OWNER TO postgres;

drop trigger if exists locationhistory_insert_configuration_change on locationhistory;

ALTER TABLE public.applicationsetting ADD COLUMN twofactorauthenabled boolean;

ALTER TABLE public.applicationsetting ADD COLUMN authenticationserver text;

ALTER TABLE public.applicationsetting ADD COLUMN emailmethod text;

ALTER TABLE public.applicationsetting ADD COLUMN emailcloudusername text;

ALTER TABLE public.applicationsetting ADD COLUMN emailcloudpassword text;

ALTER TABLE public.sysuser ADD COLUMN verificationcode text;

ALTER TABLE public.sysuser ADD COLUMN verificationcodecreated timestamp with time zone;

ALTER TABLE public.sysuser ADD COLUMN verificationattempts integer;

ALTER TABLE public.session ADD COLUMN staysignedin boolean;
