﻿
drop view public.v_assetvtag;

CREATE OR REPLACE VIEW public.v_assetvtag AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname,
	COALESCE(l.site, 'Missing'::text) AS locationsite,
    COALESCE(l.building, 'Missing'::text) AS locationbuilding,
    COALESCE(l.floor, 'Missing'::text) AS locationfloor,
    COALESCE(l.room, 'Missing'::text) AS locationroom,
    COALESCE(l.description, 'Missing'::text) AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed
  WHERE (NOT a.vtagid IS NULL) OR (NOT a.vtaggpsdeviceid IS NULL)
  ORDER BY a.vtagid;

ALTER TABLE public.v_assetvtag
  OWNER TO postgres;
