﻿ALTER TABLE public.applicationsetting ADD COLUMN vtaggpsserveraddress TEXT;
ALTER TABLE public.applicationsetting ADD COLUMN vtaggpsserverport INT;
ALTER TABLE public.applicationsetting ADD COLUMN vtaggpsserverusername TEXT;
ALTER TABLE public.applicationsetting ADD COLUMN vtaggpsserverpassword TEXT;
ALTER TABLE public.asset ADD COLUMN vtaggpsdeviceid TEXT;
ALTER TABLE public.asset ADD COLUMN vtaggpsappkey TEXT;
ALTER TABLE public.asset ADD COLUMN deviceregistered boolean DEFAULT false;
ALTER TABLE public.reader ADD COLUMN deviceregistered boolean DEFAULT false;
ALTER TABLE public.reader ADD COLUMN vtaggpsgatewayid TEXT;

drop view public.v_asset;

CREATE OR REPLACE VIEW public.v_asset AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname,
	COALESCE(l.site, 'Missing'::text) AS locationsite,
    COALESCE(l.building, 'Missing'::text) AS locationbuilding,
    COALESCE(l.floor, 'Missing'::text) AS locationfloor,
    COALESCE(l.room, 'Missing'::text) AS locationroom,
    COALESCE(l.description, 'Missing'::text) AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed;

ALTER TABLE public.v_asset
  OWNER TO postgres;

drop view public.v_assetvtag;

CREATE OR REPLACE VIEW public.v_assetvtag AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname,
	COALESCE(l.site, 'Missing'::text) AS locationsite,
    COALESCE(l.building, 'Missing'::text) AS locationbuilding,
    COALESCE(l.floor, 'Missing'::text) AS locationfloor,
    COALESCE(l.room, 'Missing'::text) AS locationroom,
    COALESCE(l.description, 'Missing'::text) AS locationdescription,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed
  WHERE NOT a.vtagid IS NULL
  ORDER BY a.vtagid;

ALTER TABLE public.v_assetvtag
  OWNER TO postgres;
