﻿drop view public.v_asset;

CREATE OR REPLACE VIEW public.v_asset AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed;

ALTER TABLE public.v_asset
  OWNER TO postgres;

drop view public.v_assetvtag;

CREATE OR REPLACE VIEW public.v_assetvtag AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname,
    COALESCE(fvt.name, fvt.vtagid) AS nearestfixedname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
     LEFT JOIN fixedvtag fvt on fvt.vtagid=a.nearestfixed
  WHERE NOT a.vtagid IS NULL
  ORDER BY a.vtagid;

ALTER TABLE public.v_assetvtag
  OWNER TO postgres;
