﻿CREATE OR REPLACE FUNCTION process_locationhistory_insert_configuration_change() RETURNS TRIGGER AS $config_audit$ 
   BEGIN 
       IF(TG_OP = 'INSERT') THEN 
           INSERT INTO configurationchange(modifiedtable, changeevent, recordid, madeby) SELECT 'LocationHistory', 'Add', NEW.id, 'trigger_script';
           RETURN NEW; 
       END IF; 
       RETURN NULL; --result is ignored since this is an AFTER trigger 
   END;
$config_audit$ LANGUAGE plpgsql;

CREATE TRIGGER locationhistory_insert_configuration_change
AFTER INSERT ON locationhistory
    FOR EACH ROW EXECUTE PROCEDURE process_locationhistory_insert_configuration_change();
