﻿ALTER TABLE public.asset add column latitude numeric, add column longitude numeric, add column altitude numeric,add column numberofsatellites integer, add column gpsaccuracy integer, add column lastgpsfix timestamp with time zone, add column vtagtype text, add column parentvtag text;

ALTER TABLE public.sensorreading add column latitude numeric, add column longitude numeric, add column altitude numeric,add column numberofsatellites integer, add column gpsaccuracy integer, add column lastgpsfix timestamp with time zone, add column vtagtype text, add column nearestfixed text,add column parentvtag text;

ALTER TABLE public.fixedvtag add column vtagtype text;

ALTER TABLE public.applicationsetting add column dateformat text;

ALTER TABLE public.maparea add column geo1latitude numeric, add column geo1longitude numeric, add column geo1pixelsx numeric, add column geo1pixelsy numeric, add column geo2latitude numeric, add column geo2longitude numeric, add column geo2pixelsx numeric, add column geo2pixelsy numeric;

drop view public.v_asset;

CREATE OR REPLACE VIEW public.v_asset AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid;

ALTER TABLE public.v_asset
  OWNER TO postgres;

drop view public.v_assetvtag;

CREATE OR REPLACE VIEW public.v_assetvtag AS 
 SELECT a.*,
    COALESCE(l.name, 'Missing'::text) AS locationname
   FROM asset a
     LEFT JOIN location l ON l.id = a.locationid
  WHERE NOT a.vtagid IS NULL
  ORDER BY a.vtagid;

ALTER TABLE public.v_assetvtag
  OWNER TO postgres;

drop view public.v_fixedvtag;

CREATE OR REPLACE VIEW public.v_fixedvtag AS 
 SELECT COALESCE(l.name, 'Missing'::text) AS locationname,
    r.name AS readername,
    vt.*
   FROM fixedvtag vt
     LEFT JOIN location l ON l.id = vt.locationid
     LEFT JOIN reader r ON r.id = vt.readerid
  ORDER BY vt.vtagid;

ALTER TABLE public.v_fixedvtag
  OWNER TO postgres;

drop view public.v_sensorreading;

CREATE OR REPLACE VIEW public.v_sensorreading AS 
select appSetting.TemperatureFormat, sr.id,sr.vtagid,sr.name,sr.created,sr.sourcedistancehops,sr.ttl,sr.minimumhumiditypercent,sr.maximumhumiditypercent,sr.batteryvolts,sr.z,sr.locationconfidence,sr.maximumaccelerationg,sr.maximumlightlevellux,sr.latitude,sr.longitude,sr.altitude,sr.numberofsatellites,sr.lastgpsfix,sr.vtagtype,sr.gpsaccuracy,sr.parentvtag,
CASE WHEN UseMeters=true THEN x ELSE ROUND(x * 3.28, 2) END AS x,
CASE WHEN UseMeters=true THEN y ELSE ROUND(y * 3.28, 2) END AS y,
CASE WHEN TemperatureFormat='Fahrenheit' THEN ROUND(minimumtemperaturedegc * 9 / 5 + 32, 2) ELSE minimumtemperaturedegc END AS minimumtemperaturedegc,
CASE WHEN TemperatureFormat='Fahrenheit' THEN ROUND(maximumtemperaturedegc * 9 / 5 + 32, 2) ELSE maximumtemperaturedegc END AS maximumtemperaturedegc
from sensorreading sr CROSS JOIN applicationsetting AS appSetting;

ALTER TABLE public.v_sensorreading
  OWNER TO postgres;
